% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badge.R
\name{Badge}
\alias{Badge}
\title{The Badge class is used to create badges.}
\description{
The Badge class is used to create badges.

The Badge class is used to create badges.
}
\details{
It is likely easier to use the \code{\link{create_badge}}
to create the badge svg in a single step.
}
\examples{

## ------------------------------------------------
## Method `Badge$new`
## ------------------------------------------------

tmp <- tempfile()
b <- Badge$new(label = "Pipeline",
               value = "Passing")
b$create_svg(tmp)

## ------------------------------------------------
## Method `Badge$create_svg`
## ------------------------------------------------

tmp <- tempfile()
b <- Badge$new(label = "Any",
               value = "Badger")
b$create_svg(tmp)

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Badge$new()}}
\item \href{#method-create_svg}{\code{Badge$create_svg()}}
\item \href{#method-clone}{\code{Badge$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Badge constructor

Used to create badge object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Badge$new(
  label,
  value,
  color = "#4c1",
  num_padding_chars = 0.5,
  thresholds = NULL,
  font_name = "DejaVu Sans,Verdana,Geneva,sans-serif",
  font_size = 11,
  label_text_color = "#fff",
  value_text_color = "#fff",
  svg_template_path = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{left hand side of badge, e.g. "pipeline" in pipeline status badge}

\item{\code{value}}{right hand side of badge, e.g. "passing" in pipeline status badge}

\item{\code{color}}{to view available colors:
\code{config::get("colors", file = anybadger:::get_sys("config.yml")) }
alternatively you can also pass in the hex of your desired color. For instance,
"#fe7d37" or "orange", either is accepted.}

\item{\code{num_padding_chars}}{NULL, can be passed in, but calculated automatically based on text length}

\item{\code{thresholds}}{TODO, thresholds are not implemented yet, coming soon!}

\item{\code{font_name}}{NULL, valid svg font will work, but sizing might be off}

\item{\code{font_size}}{NULL, if passng custom svg font}

\item{\code{label_text_color}}{NULL, set this to change the label text color}

\item{\code{value_text_color}}{NULL, set this to change the value text color}

\item{\code{svg_template_path}}{NULL, to use a different template in svg (not recommended)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tmp <- tempfile()
b <- Badge$new(label = "Pipeline",
               value = "Passing")
b$create_svg(tmp)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-create_svg"></a>}}
\subsection{Method \code{create_svg()}}{
Fills in the svg template
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Badge$create_svg(path = "default_badge.svg")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{file path to save badge svg to}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly returns the svg text
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{tmp <- tempfile()
b <- Badge$new(label = "Any",
               value = "Badger")
b$create_svg(tmp)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Badge$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
