% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll_recovery.R
\name{nll_recovery}
\alias{nll_recovery}
\title{Negative log-likelihood function: recovery model}
\usage{
nll_recovery(
  a1 = a1,
  b1 = b1,
  a2 = a2,
  b2 = b2,
  a3 = a3,
  b3 = b3,
  data = data,
  d1 = "",
  d2 = "",
  d3 = ""
)
}
\arguments{
\item{a1, b1}{location & scale parameters for background mortality}

\item{a2, b2}{location & scale parameters for mortality due to infection}

\item{a3, b3}{location & scale parameters for how long infection 'survives'}

\item{data}{a data.frame with the data}

\item{d1, d2, d3}{probability distributions for background mortality, mortality
due to infection & how long infection 'survives' ("Weibull", "Gumbel",
"Frechet")}
}
\value{
numeric
}
\description{
Function returning negative log-likelihood (nll) for patterns of survival in
infected and uninfected treatments, when infected hosts can recover from
infection.
}
\details{
This model assumes all the hosts in an infected treatment are all initially
infected, and they can all potentially recover from infection. Recovered
hosts are assumed to only experience background mortality equivalent to that
experienced by matching uninfected or control individuals; no assumptions are
made as to whether they are still infected or infectious. It is also assumed
that the timing of recovery from infection is not directly observed, but an
individual's infected/recovery status can be determined after they have died
or been censored.

The probability that an infection 'survives' over time, i.e., the host does
not recover from infection, is assumed to follow a probability distribution
which acts independently of the probability distributions determining
background mortality or mortality due to infection.

This function only estimates location and scale parameters as constants, it
is not designed to estimate them as functions.
}
\section{Warning}{
 requires the data to be specified in a specific format;
see vignette 'data format' for details
}

\examples{
\donttest{
# NB the data to analyse needs to be in a data frame of a specific form
  head(recovery_data)

# step #1: prepare nll function for analysis
  m01_prep_function <- function(a1, b1, a2, b2, a3, b3){
    nll_recovery(a1, b1, a2, b2, a3, b3,
                 data = recovery_data,
                 d1 = "Weibull", d2 = "Weibull", d3 = "Weibull"
                 )}

# step #2: send 'prep_function' to mle2 for maximum likelihood estimation,
  # specifying starting values
  m01 <- mle2(m01_prep_function,
    start = list(a1 = 2, b1 = 0.5, a2 = 2, b2 = 0.5, a3 = 2, b3 = 0.5)
    )

  summary(m01)

# values used to simulate data were for the Weibull distribution;
  # a1 = 2.8, b1 = 0.5, a2 = 2.2, b2 = 0.35, a3 = 2.35, b3 = 0.35
  }
}
