% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.r
\name{pca}
\alias{pca}
\alias{prcomp.annmatrix}
\title{Principal Component Analysis for annmatrix Objects}
\usage{
\method{prcomp}{annmatrix}(
  x,
  retx = TRUE,
  center = TRUE,
  scale. = FALSE,
  tol = NULL,
  rank. = NULL,
  ...
)
}
\arguments{
\item{x}{annmatrix object.}

\item{retx}{logical indicator whether the rotated variables should be returned (defaults to TRUE).}

\item{center}{logical value indicating whether variables should be centered (defaults to TRUE).}

\item{scale.}{logical value indicating whether variables should be scaled (defaults to FALSE).}

\item{tol}{tolerance value indicating magnitude below which components will be omitted.}

\item{rank.}{number specifying the maximal rank (max number of principal components to be used).}

\item{...}{arguments passed to or from other methods.}
}
\value{
prcom object with rotation and x matrices turned into annmatrix
}
\description{
Performs principal component analysis on annmatrix objects and preserves row and column annotations in scores and loadings.
}
\details{
The resulting loadings ('rotation') and scores ('x') are turned into annmatrix objects with additional row and column annotations.
Row annotations are copied from the original input matrix while column annotations contain computed information about each principal component.
The added information contains: 1) principal component number, 2) standard deviation, 3) variance, 4) fraction of variance explained.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)

coldata <- data.frame(group  = rep(c("case", "control"), each = 5),
                      gender = sample(c("M", "F"), 10, replace = TRUE))

rowdata <- data.frame(chr = sample(c("chr1", "chr2"), 20, replace = TRUE),
                      pos = runif(20, 0, 1000000))

X <- annmatrix(x, rowdata, coldata)

pca <- prcomp(t(X))
pca$rotation
pca$rotation$''

scores <- t(pca$rotation) \%*\% X
scores@var_explained
scores$gender

}
\author{
Karolis Koncevičius
}
