% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_all_bounding_boxes}
\alias{plot_all_bounding_boxes}
\title{Plot all bounding boxes in a manifest}
\usage{
plot_all_bounding_boxes(
  manifest,
  out_dir,
  file_col = "filepath",
  min_conf = 0.1,
  label_col = FALSE,
  show_confidence = FALSE,
  colors = NULL,
  detector_labels = NULL
)
}
\arguments{
\item{manifest}{manifest of detections}

\item{out_dir}{Name of the output directory}

\item{file_col}{Column name containing file paths}

\item{min_conf}{Confidence threshold to plot the box}

\item{label_col}{Column name containing class to print above the box. If None, no label is printed.}

\item{show_confidence}{If true, show confidence score above the box.}

\item{colors}{Named list mapping class labels to BGR colors for the bounding boxes.}

\item{detector_labels}{Named list mapping detector categories to human-readable labels.}
}
\value{
None
}
\description{
Plot all bounding boxes in a manifest
}
\examples{
\dontrun{plot_all_bounding_boxes(manifest, 'Plots/', label_col='prediction',
                                 show_confidence=TRUE, 
                                 colors=list("1" = c(0, 255, 0),
                                             "2" = c(0, 0, 255),
                                             "3" = c(255, 0, 0)))}
}
