% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{predict_species}
\alias{predict_species}
\title{Infer Species for Given Detections}
\usage{
predict_species(
  detections,
  model,
  classes,
  device = NULL,
  out_file = NULL,
  raw = FALSE,
  file_col = "Frame",
  crop = TRUE,
  resize_width = 299,
  resize_height = 299,
  normalize = TRUE,
  batch_size = 1,
  workers = 1
)
}
\arguments{
\item{detections}{manifest of animal detections}

\item{model}{loaded classifier model}

\item{classes}{data.frame of classes}

\item{device}{send model to the specified device}

\item{out_file}{path to csv to save results to}

\item{raw}{output raw logits in addition to manifest}

\item{file_col}{column in manifest containing file paths}

\item{crop}{use bbox to crop images before feeding into model}

\item{resize_width}{image width input size}

\item{resize_height}{image height input size}

\item{normalize}{normalize the tensor before inference}

\item{batch_size}{batch size for generator}

\item{workers}{number of processes}
}
\value{
detection manifest with added prediction and confidence columns
}
\description{
Infer Species for Given Detections
}
\examples{
\dontrun{animals <- predictSpecies(animals, classifier[[1]], classifier[[2]], raw=FALSE)}
}
