% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkdown.R
\name{click_to_loop}
\alias{click_to_loop}
\title{Click an element to play all frames}
\usage{
click_to_loop(selector = "#SVG_1", start = 2, wait = 20)
}
\arguments{
\item{selector}{The ID of the DOM element.}

\item{start}{An integer; the number of frames to execute upon the beginning
of the visualisation. This is useful when one wants to start with some set-up
instead of an empty canvas.}

\item{wait}{A number; the number of milliseconds to wait for before the
next frame is drawn.}
}
\description{
Playback option for the functions \link{rmd_animate}
and \link{insert_animate}.
}
\examples{
\donttest{
input <- tempfile(fileext = ".Rmd")
output <- tempfile(fileext = ".html")
writeLines('
```{r, echo = FALSE, message = FALSE}
# Run / include the following in a code chunk of an R Markdown document
library(animate)
insert_animate(system.file("tests/Lorenz_system.json.gz", package = "animate"),
               options = click_to_loop())
```
', input)
knitr::knit(input, output)
# browseURL(output)
}

}
