% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R
\docType{methods}
\name{as.list}
\alias{as.list}
\alias{as.list,CalibratedIntervals-method}
\title{Coerce to a list}
\usage{
\S4method{as.list}{CalibratedIntervals}(x, ..., calendar = get_calendar())
}
\arguments{
\item{x}{An object.}

\item{...}{Currently not used.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}
}
\value{
A \code{\link{list}}.
}
\description{
Coerce to a list
}
\examples{
## Calibrate multiple dates
cal <- c14_calibrate(
  values = c(5000, 4500),
  errors = c(45, 35),
  names = c("X", "Y")
)

head(as.data.frame(cal))
head(as.data.frame(cal, calendar = BP()))
head(as.data.frame(cal, calendar = NULL))
}
\seealso{
Other mutators: 
\code{\link{as.data.frame}()},
\code{\link{labels}()},
\code{\link{mutators}},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
