% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CalibratedAges-class}
\alias{CalibratedAges-class}
\alias{.CalibratedAges}
\title{Calibrated Radiocarbon Ages}
\arguments{
\item{values}{A \code{\link{numeric}} vector giving the BP ages or F14C values to be
calibrated.}

\item{errors}{A \code{\link{numeric}} vector giving the standard deviation of the
values to be calibrated.}

\item{curves}{A \code{\link{character}} vector specifying the calibration curves
used.}

\item{reservoir_offsets}{A \code{\link{numeric}} vector giving the offset values for
any marine reservoir effect.}

\item{reservoir_errors}{A \code{\link{numeric}} vector giving the offset value errors
for any marine reservoir effect.}
}
\description{
An S4 class to represent calibrated radiocarbon ages.
}
\section{Slots}{

\describe{
\item{\code{F14C}}{A \code{\link{logical}} scalar: is \code{values} F14C instead of radiocarbon
ages?}

\item{\code{positions}}{A \code{\link{numeric}} vector giving the position values (e.g. depths)
for each age.}

\item{\code{status}}{An \code{\link{integer}} vector specifying the calibration status.
It must be one of "\code{0}" (OK), "\code{1}" (out of calibration range) or "\code{2}"
(may extend out of calibration range).}
}}

\note{
This class inherits from \code{\link[aion:TimeSeries-class]{aion::TimeSeries}}.
}
\seealso{
Other classes: 
\code{\link{CalibratedIntervals-class}},
\code{\link{CalibratedSPD-class}},
\code{\link{ProxyRecord-class}},
\code{\link{RECE-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
