% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meld_3.R
\name{meld_3}
\alias{meld_3}
\title{MELD 3.0 Score Calculator}
\usage{
meld_3(my_data)
}
\arguments{
\item{my_data}{A data frame containing the following columns: A data frame containing the columns 'Sex', 'Creatinine', 'Bilirubin', 'INR', 'Sodium', and 'Albumin}
}
\value{
A data frame with the calculated MELD 3.0 score and risk classification of 90 day survival. Returns NA for cases with missing values.
}
\description{
The Model for End-Stage Liver Disease (MELD) is a prognostic score measuring liver failure severity and estimating short-term survival in chronic liver disease patients.
Since 2002, it has prioritized organ allocation for liver transplants. MELDNa, the second version, is used by the Organ Procurement and Transplant Network today.
Recently, MELD 3.0 was introduced to include additional variables, enhancing prediction accuracy and addressing gender disparity.
For more information, visit \url{https://www.mdcalc.com/calc/10437/model-end-stage-liver-disease-meld}.
}
\details{
The function calculates the MELD 3.0 score based on the following parameters:
\itemize{
\item \code{Sex:}  Sex (Male = 1 / Female = 0).
\item \code{Bilirubin:} Numeric value representing the bilirubin level (mg/dL).
\item \code{INR:} Numeric value representing the International Normalized Ratio (INR).
\item \code{Creatinine:} Numeric value representing the creatinine level (mg/dL).
\item \code{Albumin :} Numeric value representing the Albumin level (g/dL).
\item \code{Sodium:} Numeric value representing the serum sodium level (mEq/L).
}
}
\examples{
my_data <- data.frame(
Sex = c(1, 0, 1),
Creatinine = c(1.5, 2.0, 3.1),
Bilirubin = c(1.2, 2.5, 1.8),
INR = c(1.1, 1.4, 2.0),
Sodium = c(135, 130, 140),
Albumin = c(3.0, 2.5, 3.5))

meld_3(my_data)

}
\references{
Kamath et al. (2001) \url{doi:10.1053/jhep.2001.22172}
}
