% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{mca_align}
\alias{mca_align}
\title{Align MCA solution via Procrustes rotation with sign anchoring}
\usage{
mca_align(G, Gref)
}
\arguments{
\item{G}{Matrix of category coordinates to align (M x K)}

\item{Gref}{Reference matrix of category coordinates (M x K)}
}
\value{
List containing:
  \item{G_aligned}{Matrix of aligned category coordinates (M x K), 
    rotated and sign-corrected to match the reference}
  \item{R}{Orthogonal rotation matrix (K x K) used for alignment}
}
\description{
Performs orthogonal Procrustes rotation to align a set of category 
coordinates to a reference solution, then applies sign correction to
maximize agreement with the reference on each dimension.
}
\examples{
# Create example matrices
set.seed(123)
Gref <- matrix(rnorm(20), nrow = 10, ncol = 2)
G <- Gref \%*\% matrix(c(0.8, 0.6, -0.6, 0.8), 2, 2)

# Align G to Gref
aligned <- mca_align(G, Gref)
print(aligned$G_aligned)
}
