library(testthat)
library(alqrfe)

test_that("qr works", {
n = 50
m = 10
d = 2
N = n*m
x = matrix(rnorm(d*N), ncol=d, nrow=N)
subj = rep(1:n, each=m)
alpha = rnorm(n)
beta = rnorm(d)
eps = rnorm(N)
y = as.vector(x %*% beta + rep(alpha, each=m) + eps)
m1 = qr(x=x, y=y, subj=subj, tau=0.75, method="qrfe")

expect_equal(length(as.numeric(m1$alpha)), n)
expect_true(all(as.numeric(m1$alpha) != 0))
})