% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_eval.R
\name{freq_eval}
\alias{freq_eval}
\title{Calculate the precision, CV, and accuracy of frequency estimates}
\usage{
freq_eval(freq, number_skewed, TCR, numb_clones, prop_top)
}
\arguments{
\item{freq}{The output of \code{\link{freq_estimate}}}

\item{number_skewed}{The number of clones represent the top proportion of
the T cell population by frequency (this is the same \code{number_skewed}
argument used when \code{\link{create_clones}} is called)}

\item{TCR}{The clonal structure of the simulated T cell population. This is
obtained by subsetting the \code{TCR} element of the output of
\code{\link{create_clones}}}

\item{numb_clones}{Total number of distinct clones in the parent population}

\item{prop_top}{The proportion of the population in frequency represented by
the number of clones specified by \code{skewed}.}
}
\value{
A list with the precision, cv, and accuracy of the frequency estimation.
}
\description{
\code{freq_eval()} will evaluated how well \code{\link{freq_estimate}} performed
by calculating the precision and CV of the frequency estimates for the top
clones and by determining the proportion of the top clones whose true clonal
frequency lies in the 95-percent CI determined by \code{\link{freq_estimate}}
}

