% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/almanac-deprecated.R
\name{rset-add}
\alias{rset-add}
\alias{add_rschedule}
\alias{add_rdates}
\alias{add_exdates}
\title{Deprecated rset helpers}
\usage{
add_rschedule(x, rschedule)

add_rdates(x, rdates)

add_exdates(x, exdates)
}
\arguments{
\item{x}{\verb{[rset]}

An rset to add to.}

\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule, runion, rintersect, or rsetdiff.}

\item{rdates}{\verb{[Date]}

Dates to forcibly include in the rset.}

\item{exdates}{\verb{[Date]}

Dates to forcibly exclude from the rset.}
}
\value{
An updated rset.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
\itemize{
\item \code{add_rschedule()} is deprecated in favor of using the \code{...} arguments of
\code{\link[=runion]{runion()}}, \code{\link[=rintersect]{rintersect()}}, and \code{\link[=rsetdiff]{rsetdiff()}} directly.
\item \code{add_rdates()} is deprecated in favor of using \code{\link[=runion]{runion()}} in combination
with a custom \code{\link[=rcustom]{rcustom()}} rschedule holding the required dates.
\item \code{add_exdates()} is deprecated in favor of using \code{\link[=rsetdiff]{rsetdiff()}} in combination
with a custom \code{\link[=rcustom]{rcustom()}} rschedule holding the excluded dates.
}
}
\examples{
on_thanksgiving <- yearly() \%>\%
  recur_on_day_of_week("Thurs", nth = 4) \%>\%
  recur_on_month_of_year("Nov")

on_christmas <- yearly() \%>\%
  recur_on_day_of_month(25) \%>\%
  recur_on_month_of_year("Dec")

on_labor_day <- monthly() \%>\%
  recur_on_month_of_year("Sep") \%>\%
  recur_on_day_of_week("Mon", nth = 1)

# Rather than:
if (FALSE) {
rb <- runion() \%>\%
  add_rschedule(on_thanksgiving) \%>\%
  add_rschedule(on_christmas) \%>\%
  add_rschedule(on_labor_day)
}

# Use the `...` of the `runion()` helper directly:
rb <- runion(on_thanksgiving, on_christmas, on_labor_day)

# Thanksgiving, Christmas, or Labor Day
alma_search("2019-01-01", "2021-01-01", rb)

# Except Labor Day in 2019
# Rather than:
if (FALSE) {
rb2 <- add_exdates(rb, "2019-09-02")
}

# We recommend:
rb2 <- rsetdiff(rb, rcustom("2019-09-02"))

alma_search("2019-01-01", "2021-01-01", rb2)
}
\keyword{internal}
