% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radjusted.R
\name{radjusted}
\alias{radjusted}
\title{Create an adjusted rschedule}
\usage{
radjusted(rschedule, adjust_on, adjustment)
}
\arguments{
\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule, runion, rintersect, or rsetdiff.}

\item{adjust_on}{\verb{[rschedule]}

An rschedule that determines when the \code{adjustment} is to be applied.}

\item{adjustment}{\verb{[function]}

An adjustment function to apply to problematic dates. Typically one
of the pre-existing adjustment functions, like \code{\link[=adj_nearest]{adj_nearest()}}.

A custom adjustment function must have two arguments \code{x} and \code{rschedule}.
\code{x} is the complete vector of dates that possibly need adjustment.
\code{rschedule} is the rschedule who's event set determines when an
adjustment needs to be applied. The function should adjust \code{x} as required
and return the adjusted Date vector.}
}
\value{
An adjusted rschedule.
}
\description{
\code{radjusted()} creates a new adjusted rschedule on top of an existing one. The
new rschedule contains the same event dates as the existing rschedule,
except when they intersect with the dates in the event set of the
rschedule, \code{adjust_on}. In those cases, an \code{adjustment} is applied to the
problematic dates to shift them to valid event dates.

This is most useful when creating corporate holiday rschedules. For example,
Christmas always falls on December 25th, but if it falls on a Saturday,
your company might observe Christmas on the previous Friday. If it falls
on a Sunday, you might observe it on the following Monday. In this case,
you could construct an rschedule for a recurring event of December 25th,
and a second rschedule for weekends. When Christmas falls on a weekend,
you would apply an adjustment of \code{\link[=adj_nearest]{adj_nearest()}} to get the observance date.
}
\examples{
since <- "2000-01-01"
until <- "2010-01-01"

on_christmas <- yearly(since = since, until = until) \%>\%
  recur_on_month_of_year("Dec") \%>\%
  recur_on_day_of_month(25)

# All Christmas dates, with no adjustments
alma_events(on_christmas)

on_weekends <- weekly(since = since, until = until) \%>\%
  recur_on_weekends()

# Now all Christmas dates that fell on a weekend are
# adjusted either forwards or backwards, depending on which
# non-event date was closer
on_adj_christmas <- radjusted(on_christmas, on_weekends, adj_nearest)

alma_events(on_adj_christmas)
}
