% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alma-next.R
\name{alma_next}
\alias{alma_next}
\alias{alma_previous}
\title{Generate the next or previous event}
\usage{
alma_next(x, rschedule, inclusive = FALSE)

alma_previous(x, rschedule, inclusive = FALSE)
}
\arguments{
\item{x}{\verb{[Date]}

A vector of dates.}

\item{rschedule}{\verb{[rschedule]}

An rschedule, such as an rrule, runion, rintersect, or rsetdiff.}

\item{inclusive}{\verb{[logical(1)]}

If \code{x} is an event, should it be considered the next or previous event?}
}
\value{
A Date vector the same size as \code{x}.
}
\description{
\itemize{
\item \code{alma_next()} generates the next event after \code{x}.
\item \code{alma_previous()} generates the previous event before \code{x}.
}
}
\examples{
on_12th <- monthly() \%>\% recur_on_day_of_month(12)
on_monday <- weekly() \%>\% recur_on_day_of_week("Monday")

# On the 12th of the month, or on Mondays
rb <- runion(on_12th, on_monday)

alma_next(c("2019-01-01", "2019-01-11"), rb)
alma_previous(c("2019-01-01", "2019-01-11"), rb)
}
