% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormal.R
\name{lognormal}
\alias{lognormal}
\title{Construct a log-normal distribution object.}
\usage{
lognormal(meanlog = 0, sdlog = 1)
}
\arguments{
\item{meanlog}{Mean of the distribution on the log scale (default 0).}

\item{sdlog}{Standard deviation on the log scale (default 1), must be
positive.}
}
\value{
A \code{lognormal} object with classes
\code{c("lognormal", "univariate_dist", "continuous_dist", "dist")}.
}
\description{
Creates an S3 object representing a log-normal distribution with the given
\code{meanlog} and \code{sdlog} parameters. The log-normal PDF is
\deqn{f(t) = \frac{1}{t \cdot sdlog \sqrt{2\pi}}
  \exp\!\left(-\frac{(\log t - meanlog)^2}{2 \cdot sdlog^2}\right)}
for \eqn{t > 0}.
}
\examples{
x <- lognormal(meanlog = 0, sdlog = 1)
mean(x)
vcov(x)
format(x)
}
