% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_dist.R
\name{expectation.univariate_dist}
\alias{expectation.univariate_dist}
\title{Method for obtaining the expectation of \code{f} with respect to a
\code{univariate_dist} object \code{x}.}
\usage{
\method{expectation}{univariate_dist}(x, g, ..., control = list())
}
\arguments{
\item{x}{The distribution object.}

\item{g}{The function to take the expectation of.}

\item{...}{Additional arguments to pass into \code{g}.}

\item{control}{An (optional) list of control parameters for \code{integrate} or
\code{expectation_data} (if \code{x} is not continuous)}
}
\value{
The expected value (numeric scalar), or the full
\code{integrate()} result if \code{compute_stats = TRUE}.
}
\description{
Assumes the support is a contiguous interval that has operations
for retrieving the lower and upper bounds.
}
\examples{
x <- normal(3, 4)
# E[X] for Normal(3, 4) is 3
expectation(x, function(t) t)

# E[X^2] for Exp(1) is 2
expectation(exponential(1), function(t) t^2)
}
