% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edist.R
\name{-.dist}
\alias{-.dist}
\title{Method for negation or subtraction of \code{dist} objects.}
\usage{
\method{-}{dist}(x, y)
}
\arguments{
\item{x}{A \code{dist} object or numeric scalar}

\item{y}{A \code{dist} object or numeric scalar (optional for unary negation)}
}
\value{
A simplified distribution or \code{edist} if no closed form exists
}
\description{
Unary: returns negated distribution (e.g., -N(mu, var) = N(-mu, var))
Binary: creates expression distribution and simplifies to closed form
when possible (e.g., normal - normal = normal, normal - scalar = normal).
}
\examples{
# Difference of normals simplifies to a normal
z <- normal(5, 2) - normal(1, 3)
z  # Normal(mu = 4, var = 5)

# Unary negation
-normal(3, 1)  # Normal(mu = -3, var = 1)
}
