% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AxialShapeGraph.R
\docType{methods}
\name{unlinkRefs,AxialShapeGraph-method}
\alias{unlinkRefs,AxialShapeGraph-method}
\title{Unlink two Axial Lines (refs)}
\usage{
\S4method{unlinkRefs}{AxialShapeGraph}(map, fromRef, toRef, copyMap = TRUE)
}
\arguments{
\item{map}{An Axial ShapeGraph}

\item{fromRef}{Ref of the first unlink line}

\item{toRef}{Ref of the second unlink line}

\item{copyMap}{Optional. Copy the internal sala map}
}
\value{
A new Axial ShapeGraph with unlinked lines
}
\description{
Unlink two lines on an Axial ShapeGraph using their refs
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
unlinkRefs(shapeGraph, 12L, 34L)
}
