.eqn3legacy <- function() if (
	getRversion() < '4.2' || nzchar(Sys.getenv('ALBATROSS_LEGACY_EQN3'))
) 'html' else 'FALSE'

.Rdcite.env <- new.env(parent = emptyenv())
# also ensures other invariants (e.g. $cited exists)
.Rdcite.db <- function() {
	if (!exists('db', envir = .Rdcite.env))
		.Rdcite.env$db <- utils::readCitationFile(
			system.file('REFERENCES', package = 'albatross'),
			list(Encoding = 'UTF-8')
		)
	if (!exists('cited', envir = .Rdcite.env))
		.Rdcite.env$cited <- character()
	.Rdcite.env$db
}
.Rdcite <- function(key) {
	db <- .Rdcite.db()
	if (!length(db[[key]])) stop(
		dQuote(key), ' not found in REFERENCES'
	)

	# set of keys already cited
	.Rdcite.env$cited <- union(.Rdcite.env$cited, key)

	utils::cite(key, db)
}
.Rdbibliography <- function() {
	db <- .Rdcite.env$db
	cited <- .Rdcite.env$cited
	stopifnot(!is.null(db), length(cited) > 0)
	.Rdcite.env$cited <- character()

	ret <- tools::toRd(db[cited])
	# Prior to R-4.6.0 (PR18470), newline-separated paragraphs
	# originating from a \Sexpr weren't recognised by Rd2HTML. So rely
	# on manually-produced paragraphs in HTML output, normal paragraphs
	# elsewhere.
	# TODO(R>=4.6.0): replace with paste(ret, collapse='\n\n')
	paste(
		c('', rep('\\ifelse{html}{\\out{<p>}}{\n\n}', length(ret)-1)), ret,
		collapse = '\n'
	)
}
.Rdreference <- function(key) {
	entry <- .Rdcite.db()[[key]]
	if (!length(entry)) stop(
		dQuote(key), ' not found in REFERENCES'
	)
	tools::toRd(entry)
}
