% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials.R
\name{get_airnow_token}
\alias{get_airnow_token}
\alias{set_airnow_token}
\title{Manage AirNow API Tokens}
\usage{
get_airnow_token(ask = is_interactive())

set_airnow_token(token = NULL, ask = is_interactive())
}
\arguments{
\item{ask}{Whether or not to ask for the key if none is provided. Note that
this only works for interactive sessions.}

\item{token}{Token to use}
}
\value{
\code{get_airnow_token()} returns a string containing the current
user or group key or an empty string if not set. If the user is not set but
\code{ask} is \code{TRUE}, the user will be prompted for a key.
}
\description{
\code{get_airnow_token()} returns the configured AirNow API token or
errors if it is not set.

\code{set_airnow_token()} sets the AirNow API token to the given
value for the current session. To use this permanently, save it as
\code{AIRNOW_API_KEY} in your \verb{~/.Renviron} file.
}
\examples{
\dontrun{
get_airnow_token()
}
\dontrun{
set_airnow_token(token = "4d36e978-e325-11cec1-08002be10318")
}
}
