% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_airnow_forecast.R
\name{get_airnow_forecast}
\alias{get_airnow_forecast}
\title{Get air quality forecast}
\usage{
get_airnow_forecast(
  zip = NULL,
  latitude = NULL,
  longitude = NULL,
  distance = NULL,
  date = NULL,
  clean_names = TRUE,
  api_key = get_airnow_token()
)
}
\arguments{
\item{zip}{ZIP code, a 5-digit numeric string (e.g., \code{"90210"})}

\item{latitude}{Latitude in decimal degrees}

\item{longitude}{Longitude in decimal degrees}

\item{distance}{Optional. If no reporting area is associated with the given
\code{zip} code, current observations from a nearby reporting area within this
distance (in miles) will be returned, if available.}

\item{date}{Optional date of forecast. If this is not specified, the current
forecast is returned.}

\item{clean_names}{Whether or not column names should be cleaned (default:
\code{TRUE})}

\item{api_key}{AirNow API key}
}
\value{
A data frame with current air quality conditions
}
\description{
\code{get_airnow_forecast()} retrieves forecasted air quality conditions
for the given location. Locations can be specified either by ZIP code
(\code{zip}), or by \code{latitude}/\code{longitude}. If no data exist for the specified
location, an optional search radius for other sites can be specified using
\code{distance}.
}
\examples{
\dontrun{
get_airnow_forecast(zip = "90210")
}

}
