% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.tai.R
\name{stability.tai}
\alias{stability.tai}
\title{Tai's stability analysis}
\usage{
stability.tai(dataf, res_var, gen_var, env_var, rep_var, plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a list of two objects:
\describe{
  \item{ANOVA}{the analysis of variance table}
  \item{scores}{the data frame object of stability analysis results:}
  \itemize{
    \item{\code{alpha} regression of genotype means on environmental means}
    \item{\code{t_value} t-values for gypothesis that alpha=0}
    \item{\code{p_value} p-values for gypothesis that alpha=0 }
    \item{\code{lambda} deviation from linear responses}
    \item{\code{pf_value} p-values for gypothesis that lambda=0 }
}
}
}
\description{
This function calculates the Tai's stability parameters.
}
\examples{
data(exp_data)
stability.tai(exp_data,"yield","gen","env","rep")
}
\references{
Tai, G.C.C. 1971. Genotypic stability analysis and application to potato regional trials. Crop Sci. 11: 184-190. doi:10.2135/cropsci1971.0011183X001100020006x
}
