% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.hom.R
\name{stability.hom}
\alias{stability.hom}
\title{Coefficient of homeostaticity}
\usage{
stability.hom(dataf, res_var, gen_var, env_var, rep_var, plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a data frame:
\describe{
  \item{mean_all}{the genotype's mean}
  \item{mean_opt}{the genotype's max yield value}
  \item{mean_lim}{the genotype's min yield value}
  \item{sd}{the genotype's standard deviation}
  \item{hom}{the genotype's coefficient of homeostaticity}
}
}
\description{
This function calculates the Khangildin's coefficient of homeostaticity
}
\examples{
data(exp_data)
stability.hom(exp_data,"yield","gen","env","rep")
}
\references{
Khangildin V.V., Shayakhmetov I.F., Mardamshin A.G. 1979. Homeostasis of crop components and prerequisites for creating a model of a spring wheat variety. In Genetic analysis of quantitative traits of plants, 5-39. Ufa. (In Russian)
}
