% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-examples.R
\name{pord_nd}
\alias{pord_nd}
\title{Weak Dominance Relation (Preorder)}
\usage{
pord_nd(x, y, incompatible_lengths = NA)
}
\arguments{
\item{x}{numeric vector with nonnegative elements}

\item{y}{numeric vector with nonnegative elements}

\item{incompatible_lengths}{single logical value,
value to return iff lengths of \code{x} and \code{y} differ}
}
\value{
Returns a single logical value
indicating whether \code{x} is weakly
dominated by \code{y}.
}
\description{
Checks whether a numeric vector
of arbitrary length is (weakly) dominated (elementwise)
by another vector of the same length.
}
\details{
We say that a numeric vector \bold{x}
of length \eqn{n_x}
is \emph{weakly dominated} by \bold{y}
of length \eqn{n_y}
iff
\enumerate{
\item \eqn{n_x=n_y} and
\item for all \eqn{i=1,\dots,n_x} it holds
   \eqn{x_i\le y_i}.
}

This relation is a preorder: it is reflexive (see \code{\link{rel_is_reflexive}})
and transitive (see \code{\link{rel_is_transitive}}),
but not necessarily total  (see \code{\link{rel_is_total}}).
See \code{\link{rel_graph}} for a convenient function
to calculate the relationship between all pairs of elements
of a given set.

Such a preorder is tightly related to classical aggregation functions:
each aggregation function is a morphism between
weak-dominance-preordered set of vectors
and the set of reals equipped with standard linear ordering.
}
\references{
Grabisch M., Marichal J.-L., Mesiar R., Pap E., \emph{Aggregation functions},
   Cambridge University Press, 2009.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other binary_relations: 
\code{\link{check_comonotonicity}()},
\code{\link{pord_spread}()},
\code{\link{pord_weakdom}()},
\code{\link{rel_graph}()},
\code{\link{rel_is_antisymmetric}()},
\code{\link{rel_is_asymmetric}()},
\code{\link{rel_is_cyclic}()},
\code{\link{rel_is_irreflexive}()},
\code{\link{rel_is_reflexive}()},
\code{\link{rel_is_symmetric}()},
\code{\link{rel_is_total}()},
\code{\link{rel_is_transitive}()},
\code{\link{rel_reduction_hasse}()}
}
\concept{binary_relations}
