% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agops-dispersion.R
\name{d2owa_checkwts}
\alias{d2owa_checkwts}
\alias{d2owa}
\title{D2OWA Operators}
\usage{
d2owa_checkwts(w)

d2owa(x, w = rep(1/length(x), length(x)))
}
\arguments{
\item{w}{numeric vector of the same length as \code{x}, with elements in \eqn{[0,1]},
and such that \eqn{\sum_i w_i=1}{sum(x)=1}; weights}

\item{x}{numeric vector to be aggregated}
}
\value{
For \code{d2owa}, a single numeric value is returned.
On the other hand, \code{d2owa_checkwts} returns a single logical value.
}
\description{
Computes the D2OWA operator, i.e.,
the normalized L2 distance between a numeric vector and an OWA operator.
}
\details{
D2OWA is a symmetric spread measure.
It is defined as
\code{d2owa(x) == sqrt(mean((x-owa(x,w))^2))}.
Not all weights, however, generate a proper function of this kind;
\code{d2owa_checkwts} may be used to check that.
For \code{d2owa}, if \code{w} is not appropriate, an error is thrown.

\code{w} is automatically normalized so that its elements sum up to 1.
}
\references{
Gagolewski M., Spread measures and their relation to aggregation functions,
    European Journal of Operational Research 241(2), 2015, pp. 469-477.
    doi:10.1016/j.ejor.2014.08.034

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7

Yager R.R., On ordered weighted averaging aggregation operators
in multicriteria decision making, \emph{IEEE Transactions on Systems,
Man, and Cybernetics} 18(1), 1988, pp. 183-190.
}
\concept{dispersion_functions}
