% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_counts.R
\name{get_counts}
\alias{get_counts}
\title{get_counts}
\usage{
get_counts(
  path,
  epoch,
  lfe_select = FALSE,
  write.file = FALSE,
  return.data = TRUE,
  verbose = FALSE,
  tz = "UTC",
  parser = c("pygt3x", "GGIR", "read.gt3x"),
  ...
)
}
\arguments{
\item{path}{Full path name to the GT3X File}

\item{epoch}{The epoch length for which the counts should be summed.}

\item{lfe_select}{Apply the Actigraph Low Frequency Extension filter, Default: FALSE}

\item{write.file}{Export a CSV file of the counts, Default: FALSE}

\item{return.data}{Return the data frame to the R Global Environment, Default: TRUE}

\item{verbose}{Print the progress of the Actigraph raw data conversion to counts, Default: FALSE.}

\item{tz}{the desired timezone, Default: \code{UTC}}

\item{parser}{The parser to use when reading in the data. Parser values include pygt3x, GGIR, and read.gt3x options.}

\item{...}{arguments passed to \code{\link[data.table]{fwrite}}}
}
\value{
Writes a CSV file if write.file is TRUE and returns a data.frame if return.data is TRUE
}
\description{
Main function to extract counts from the Actigraph GT3X Files.
}
\details{
Main function to extract counts from the Actigraph GT3X Files.
}
\examples{
 get_counts(
  path = system.file("extdata/example.gt3x", package = "agcounts"),
  epoch = 60, lfe_select = FALSE,
  write.file = FALSE, return.data = TRUE
  )
}
\seealso{
\code{\link[read.gt3x]{read.gt3x}}
}
