% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agread.R
\name{agread}
\alias{agread}
\title{Read in raw acceleration data}
\usage{
agread(
  path,
  parser = c("pygt3x", "GGIR", "read.gt3x"),
  tz = "UTC",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{path}{Path name to the GT3X file or the dataset with columns time, X, Y, and Z axis}

\item{parser}{The parser to use when reading in the data. Parser values include pygt3x, GGIR, and read.gt3x options.}

\item{tz}{the desired timezone, Default: \code{UTC}}

\item{verbose}{Print the read method, Default: FALSE.}

\item{...}{Additional arguments to pass into the agread function}
}
\value{
Returns the raw acceleration data
}
\description{
This function reads in raw acceleration data
    with the pygt3x Python package, the read.gt3x R package with GGIR autocalibration, or the read.gt3x R package.
}
\details{
This function reads in raw acceleration data
    with the pygt3x Python package, the read.gt3x R package with GGIR autocalibration, or the read.gt3x R package.
}
\examples{
    agread(system.file("extdata/example.gt3x", package = "agcounts"), parser = "pygt3x")
}
\seealso{
\code{\link[GGIR]{g.calibrate}}
 \code{\link[read.gt3x]{read.gt3x}}
}
