% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_congruent.r
\name{is_congruent}
\alias{is_congruent}
\alias{is_congruent.numeric}
\alias{is_congruent.angle}
\title{Test whether two objects are congruent}
\usage{
is_congruent(x, y, ...)

\method{is_congruent}{numeric}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{is_congruent}{angle}(
  x,
  y,
  ...,
  mod_turns = TRUE,
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x, y}{Two objects to test whether they are \dQuote{"congruent"}.}

\item{...}{Further arguments passed to or from other methods.}

\item{tolerance}{Angles (coerced to half-turns) or numerics with differences smaller
than \code{tolerance} will be considered \dQuote{congruent}.}

\item{mod_turns}{If \code{TRUE} angles that are congruent modulo full turns will be considered \dQuote{congruent}.}
}
\value{
A logical vector
}
\description{
\code{is_congruent()} is a S3 generic that tests whether two different objects are \dQuote{congruent}.
The \code{is_congruent()} method for \code{\link[=angle]{angle()}} classes tests whether two angles are congruent.
}
\examples{
  # Use `is_congruent()` to check if two angles are "congruent"
  a1 <- angle(180, "degrees")
  a2 <- angle(pi, "radians")
  a3 <- angle(-180, "degrees") # Only congruent modulus full turns
  a1 == a2
  isTRUE(all.equal(a1, a2))
  is_congruent(a1, a2)
  is_congruent(a1, a2, mod_turns = FALSE)
  a1 == a3
  isTRUE(all.equal(a1, a3))
  is_congruent(a1, a3)
  is_congruent(a1, a3, mod_turns = FALSE)

}
