% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_coord.r
\name{as_coord1d}
\alias{as_coord1d}
\alias{as_coord1d.character}
\alias{as_coord1d.Coord2D}
\alias{as_coord1d.data.frame}
\alias{as_coord1d.list}
\alias{as_coord1d.matrix}
\alias{as_coord1d.numeric}
\alias{as_coord1d.Coord1D}
\alias{as_coord1d.Point1D}
\title{Cast to coord1d object}
\usage{
as_coord1d(x, ...)

\method{as_coord1d}{character}(x, ...)

\method{as_coord1d}{Coord2D}(
  x,
  permutation = c("xy", "yx"),
  ...,
  line = as_line2d("x-axis"),
  scale = 0
)

\method{as_coord1d}{data.frame}(x, ...)

\method{as_coord1d}{list}(x, ...)

\method{as_coord1d}{matrix}(x, ...)

\method{as_coord1d}{numeric}(x, ...)

\method{as_coord1d}{Coord1D}(x, ...)

\method{as_coord1d}{Point1D}(x, ...)
}
\arguments{
\item{x}{An object that can be cast to a \link{Coord1D} class object
such as a numeric vector of x-coordinates.}

\item{...}{Further arguments passed to or from other methods}

\item{permutation}{Either "xy" (no permutation) or "yx" (permute x and y axes)}

\item{line}{A \link{Line2D} object of length one representing the line
you with to reflect across or project to or an object coercible to one by \code{as_line2d(line, ...)}
such as "x-axis" or "y-axis".}

\item{scale}{Oblique projection scale factor.
A degenerate \code{0} value indicates an orthogonal projection.}
}
\value{
A \link{Coord1D} class object
}
\description{
\code{as_coord1d()} casts to a \link{Coord1D} class object
}
\examples{
as_coord1d(x = rnorm(10))
}
