% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{alice_dat}
\alias{alice_dat}
\title{Alice's gene data}
\format{
A tibble with 32 rows and 4 variables:
\describe{
  \item{id}{Participant ID}
  \item{picture}{A factor describing whether a participant tried to resemble a picture of themselves (Self), or a matched stranger (Other)}
  \item{gene}{A factor describing whether a participant received the toggle switch (C-gene + Toggle) or not (C-gene)}
  \item{resemblance}{How closely their face resembled the picture (100\% = the participants face is exactly like the face in the photograph, 0\% the person in the photo bears no resemblance at all to the participant)}
}
}
\source{
\url{https://www.discoveringstatistics.com/books/an-adventure-in-statistics/}
}
\usage{
alice_dat
}
\description{
A dataset relating to the following fictitious experiment:
Participants who had facial burns were recruited. One-week pre-test, a gene C-10XFMG (the so-called chameleon gene)
was introduced into all participants.Two days prior to test, a genetic toggle switch was introduced into half of the participants.
Half of the participants were asked to look at a photograph of themselves from before their injury and to imagine the cells in their faces
changing to become like the photo. The remainder acted as a control and were asked to look at a picture of a same-sex stranger and to try
to change their face to become the person in the picture. All participants looked at the picture for 6 sessions of 20 minutes each.
At the end of the sessions their faces were scanned into a computer and compared to the face in the photograph.
Facial recognition software produced a precise resemblance measure as a percentage (100% = the participants face is exactly like the face
in the photograph, 0% the person in the photo bears no resemblance at all to the participant).
The data are taken from Chapter 17 of Field, A. P. (2016). An adventure in statistics: the reality enigma. London: Sage.
}
\keyword{datasets}
