% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adproclus_classes.R
\name{adpc}
\alias{adpc}
\title{Constructor for a (low dimensional) ADPROCLUS solution object}
\usage{
adpc(
  A,
  P,
  sse = NULL,
  totvar = NULL,
  explvar = NULL,
  iterations = NULL,
  timer = NULL,
  timer_one_run = NULL,
  initial_start = NULL,
  C = NULL,
  B = NULL,
  runs = NULL,
  parameters = NULL
)
}
\arguments{
\item{A}{Membership matrix A.}

\item{P}{Profile matrix P.}

\item{sse}{Sum of Squared Error.}

\item{totvar}{Total variance.}

\item{explvar}{Explained variance.}

\item{iterations}{Number of iterations.}

\item{timer}{Time needed to run the complete algorithm.}

\item{timer_one_run}{Time to complete this single algorithm start.}

\item{initial_start}{List containing type of start and
\code{start_allocation} matrix.}

\item{C}{Low dimensional profiles matrix C.}

\item{B}{Matrix of base vectors connecting low dimensional components with
original variables B.}

\item{runs}{List of suboptimal models.}

\item{parameters}{List of algorithm parameters.}
}
\value{
Object of class \code{adpc}.
}
\description{
Yields an object of class \code{adpc}, which can be printed, plotted and
summarized by the corresponding methods. Mandatory input are the membership
matrix \eqn{A} and the profile matrix \eqn{P}
(where the number of columns from \eqn{A} corresponds to
the number of rows in \eqn{P}),
if the object is to represent a full dimensional ADPROCLUS model.
For a low dimensional ADPROCLUS model, the matrices \eqn{C}
and \eqn{B} have to be provided and \eqn{P} can
be inferred from those. All other inputs are optional but may be included
so that the output from the \code{summary(), print(), plot()} is complete.
For further details on the (low dimensional) ADPROCLUS model and
what every element of the objects means
see \code{\link{adproclus}} and \code{\link{adproclus_low_dim}}.
}
\examples{
# Create the information needed for a minimal object of class adpc
x <- stackloss
result <- adproclus(x, 3)
A <- result$A
P <- result$P

# Use constructor to obtain object of class adpc
result_object <- adpc(A, P)

}
