% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSquaredDistribution.R
\docType{class}
\name{ZSquared-class}
\alias{ZSquared-class}
\alias{ZSquared}
\alias{get_tau_ZSquared}
\title{Distribution class of a squared normal distribution}
\usage{
ZSquared(two_armed = TRUE)

get_tau_ZSquared(mu, sigma)
}
\arguments{
\item{two_armed}{logical indicating if a two-armed trial is regarded}

\item{mu}{mean of Z}

\item{sigma}{standard deviation of Z}
}
\description{
Implementation of \eqn{Z^2}, where \eqn{Z} is normally distributed with mean
\eqn{\mu} and variance \eqn{\sigma^2}. \eqn{Z^2} is chi-squared distributed
with \eqn{1} degree of freedom and non-centrality parameter \eqn{(\mu/\sigma)^2}.
The function \code{get_tau_ZSquared} computes the factor \eqn{\tau=(\mu/\sigma)^2},
such that \eqn{\tau} is the equivalent of \eqn{\theta} in the normally
distributed case. The square of a normal distribution \eqn{Z^2} can be used
for two-sided hypothesis testing.
}
\examples{
zsquared <- ZSquared(FALSE)


H1 <- PointMassPrior(get_tau_ZSquared(0.4, 1), 1)

}
