#' Demographic Dataset - Neuro
#'
#' An updated SDTM DM dataset subset with age appropriate Alzheimer's Disease patients
#' @keywords datasets
#' @family datasets
"dm_neuro"

# This file is automatically generated by data-raw/nv_neuro.R.
# Please rerun nv_enuro.R to create it again.
# Manual edits are not recommended, as changes may be overwritten.
#' Nervous System Findings Dataset
#'
#' A SDTM NV domain dataset for Alzheimer's disease observational and interventional studies, including amyloid and tau PET data at baseline and two follow-up visits reflect levels of pathology appropriate for disease or treatment course
#' @keywords datasets
#' @family datasets
#'
#' @name nv_neuro
#' @title Nervous System Findings Dataset
#' @description A SDTM NV domain dataset containing nervous system findings and measurements
#' @docType data
#' @format A data frame with 20 columns:
#'   \describe{
#'     \item{STUDYID}{Study Identifier}
#'     \item{DOMAIN}{Domain Abbreviation}
#'     \item{USUBJID}{Unique Subject Identifier}
#'     \item{NVSEQ}{Sequence Number}
#'     \item{NVLNKID}{Link ID}
#'     \item{NVTESTCD}{Short Name of Nervous System Test}
#'     \item{NVTEST}{Name of Nervous System Test}
#'     \item{NVCAT}{Category for Nervous System Test}
#'     \item{NVLOC}{Location Used for the Measurement}
#'     \item{NVMETHOD}{Method of Test or Examination}
#'     \item{NVNAM}{Vendor Name}
#'     \item{NVORRES}{Result or Finding in Original Units}
#'     \item{NVORRESU}{Original Units}
#'     \item{NVSTRESC}{Character Result/Finding in Std Format}
#'     \item{NVSTRESN}{Numeric Result/Finding in Standard Units}
#'     \item{NVSTRESU}{Standard Units}
#'     \item{VISITNUM}{Visit Number}
#'     \item{VISIT}{Visit Name}
#'     \item{NVDTC}{Date/Time of Collection}
#'     \item{NVDY}{Study Day of Collection}
#'     \item{NVLOBXFL}{Last Observation Before Exposure Flag}
#'   }
#'
#' @source Constructed using `dm_neuro` from `{admiralneuro}` package for USUBJID and cohort information, `vs` from `{pharmaversesdtm}` for visit schedule such as VISIT, NVDTC, NVDY
"nv_neuro"

# This file is automatically generated by data-raw/suppnv_neuro.R
# Please rerun suppnv_neuro.R to create it again.
# Manual edits are not recommended, as changes may be overwritten.
#' Supplemental Nervous System Findings Dataset
#'
#' A SDTM SUPPNV domain dataset
#' @keywords datasets
#' @family datasets
#'
#' @name suppnv_neuro
#' @title Supplemental Nervous System Findings Dataset
#' @description A SDTM SUPPNV domain dataset containing reference regions used for SUVR calculation
#' @docType data
#' @format A data frame with 8 columns:
#'  \describe{
#'   \item{STUDYID}{Study Identifier}
#'   \item{RDOMAIN}{Related Domain Abbreviation}
#'   \item{USUBJID}{Unique Subject Identifier}
#'   \item{IDVAR}{Identifying Variable}
#'   \item{IDVARVAL}{Identifying Variable Value}
#'   \item{QNAM}{Qualifier Variable Name}
#'   \item{QLABEL}{Qualifier Variable Label}
#'   \item{QVAL}{Data Value}
#'   \item{QORIG}{Origin}
#'   \item{QEVAL}{Evaluator}
#'   }
#' @source Constructed using `nv_neuro` from `{admiralneuro}` package
"suppnv_neuro"

# This file is automatically generated by data-raw/ag_neuro.R
# Please rerun ag_neuro.R to create it again.
# Manual edits are not recommended, as changes may be overwritten.
#' Procedure Agents for Nervous System Dataset
#'
#' A SDTM AG domain dataset
#' @keywords datasets
#' @family datasets
#'
#' @name ag_neuro
#' @title Procedure Agents for Nervous System Dataset
#' @description A SDTM AG domain dataset containing procedure agents for nervous system
#' @docType data
#' @format A data frame with 12 columns:
#' \describe{
#'  \item{STUDYID}{Study Identifier}
#'  \item{DOMAIN}{Domain Abbreviation}
#'  \item{USUBJID}{Unique Subject Identifier}
#'  \item{AGSEQ}{Sequence Number}
#'  \item{AGTRT}{Reported Agent Name}
#'  \item{AGCAT}{Category for Category}
#'  \item{AGDOSE}{Dose per Administration}
#'  \item{AGDOSEU}{Dose Units}
#'  \item{AGROUTE}{Route of Administration}
#'  \item{AGLNKID}{Link ID}
#'  \item{VISITNUM}{Visit Number}
#'  \item{VISIT}{Visit Name}
#'  \item{AGSTDTC}{Start Date/Time of Agent}
#'  }
#' @source Constructed using `nv_neuro` from `{admiralneuro}` package
"ag_neuro"

#' Amyloid PET Scan Analysis Dataset - Neuro
#'
#' An updated ADaM ADAPET dataset using NV, AG, SUPPNV, ADSL
#' @keywords datasets
#' @family datasets
"admiralneuro_adapet"

#' Tau PET Scan Analysis Dataset - Neuro
#'
#' An updated ADaM ADTPET dataset using NV, AG, SUPPNV, ADSL
#' @keywords datasets
#' @family datasets
"admiralneuro_adtpet"

#' Subject Level Analysis Dataset-updated
#'
#' An updated ADaM ADSL dataset with Alzheimer's Disease patients
#' @keywords datasets
#' @family datasets
"adsl_neuro"
