% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warnings.R
\name{warn_if_invalid_dtc}
\alias{warn_if_invalid_dtc}
\title{Warn If a Vector Contains Unknown Datetime Format}
\usage{
warn_if_invalid_dtc(dtc, is_valid = is_valid_dtc(dtc))
}
\arguments{
\item{dtc}{a character vector containing the dates

\describe{
\item{Default value}{none}
}}

\item{is_valid}{a logical vector indicating whether elements in \code{dtc} are valid

\describe{
\item{Default value}{\code{is_valid_dtc(dtc)}}
}}
}
\value{
No return value, called for side effects
}
\description{
Warn if the vector contains unknown datetime format such as
"2003-12-15T-:15:18", "2003-12-15T13:-:19","--12-15","-----T07:15"
}
\examples{

## No warning as `dtc` is a valid date format
warn_if_invalid_dtc(dtc = "2021-04-06")

## Issues a warning
warn_if_invalid_dtc(dtc = "2021-04-06T-:30:30")
}
\seealso{
Function that provide users with custom warnings
\code{\link{suppress_warning}()},
\code{\link{warn_if_incomplete_dtc}()},
\code{\link{warn_if_inconsistent_list}()},
\code{\link{warn_if_vars_exist}()}
}
\concept{warnings}
\keyword{warnings}
