% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_qtc.R
\name{default_qtc_paramcd}
\alias{default_qtc_paramcd}
\title{Get Default Parameter Code for Corrected QT}
\usage{
default_qtc_paramcd(method)
}
\arguments{
\item{method}{Method used to QT correction

\describe{
\item{Permitted values}{\code{"Bazett"}, \code{"Fridericia"}, \code{"Sagie"}}
\item{Default value}{none}
}}
}
\value{
\code{"QTCBR"} if \code{method} is \code{"Bazett"}, \code{"QTCFR"} if it's \code{"Fridericia"} or
\code{"QTLCR"} if it's \code{"Sagie"}. An error otherwise.
}
\description{
Get Default Parameter Code for Corrected QT
}
\examples{
default_qtc_paramcd("Sagie")
}
\seealso{
\code{\link[=derive_param_qtc]{derive_param_qtc()}}

BDS-Findings Functions for adding Parameters/Records:
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
