% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_date.R
\name{date_source}
\alias{date_source}
\title{Create a \code{date_source} object}
\usage{
date_source(dataset_name, filter = NULL, date, set_values_to = NULL)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the date.

\describe{
\item{Default value}{none}
}}

\item{filter}{An unquoted condition for filtering \code{dataset}.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{date}{A variable or an expression providing a date. A date or a
datetime can be specified. An unquoted symbol or expression is expected.

\describe{
\item{Default value}{none}
}}

\item{set_values_to}{Variables to be set

\describe{
\item{Default value}{\code{NULL}}
}}
}
\value{
An object of class \code{date_source}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The \code{date_source()}
function has been deprecated in favor of \code{event()}.

Create a \code{date_source} object as input for \code{derive_var_extreme_dt()} and
\code{derive_var_extreme_dtm()}.
}
\examples{

# treatment end date from ADSL
trt_end_date <- date_source(
  dataset_name = "adsl",
  date = TRTEDT
)

# lab date from LB where assessment was taken, i.e. not "NOT DONE"
lb_date <- date_source(
  dataset_name = "lb",
  filter = LBSTAT != "NOT DONE" | is.na(LBSTAT),
  date = convert_dtc_to_dt(LBDTC)
)

# death date from ADSL including traceability variables
death_date <- date_source(
  dataset_name = "adsl",
  date = DTHDT,
  set_values_to = exprs(
    LALVDOM = "ADSL",
    LALVVAR = "DTHDT"
  )
)
}
\seealso{
\code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_var_extreme_dt]{derive_var_extreme_dt()}}

Other deprecated: 
\code{\link{call_user_fun}()},
\code{\link{derive_param_extreme_record}()},
\code{\link{derive_var_dthcaus}()},
\code{\link{derive_var_extreme_dt}()},
\code{\link{derive_var_extreme_dtm}()},
\code{\link{derive_var_merged_summary}()},
\code{\link{dthcaus_source}()},
\code{\link{get_summary_records}()}
}
\concept{deprecated}
\keyword{deprecated}
