% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_joined_summary.R
\name{derive_vars_joined_summary}
\alias{derive_vars_joined_summary}
\title{Summarize Variables from an Additional Dataset Based on Conditions from Both
Datasets}
\usage{
derive_vars_joined_summary(
  dataset,
  dataset_add,
  by_vars = NULL,
  order = NULL,
  new_vars,
  tmp_obs_nr_var = NULL,
  join_vars = NULL,
  join_type,
  filter_add = NULL,
  first_cond_lower = NULL,
  first_cond_upper = NULL,
  filter_join = NULL,
  missing_values = NULL,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{new_vars}, the \code{join_vars},
and the \code{order} argument are expected.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

The two datasets are joined by the specified variables.

Variables can be renamed by naming the element, i.e.
\verb{by_vars = exprs(<name in input dataset> = <name in additional dataset>)}, similar to the \code{dplyr} joins.

\describe{
\item{Permitted values}{list of (optionally named) variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, ADY = ASTDY)}}
\item{Default value}{\code{NULL}}
}}

\item{order}{Sort order

The specified variables are used to determine the order of the records if
\code{first_cond_lower} or \code{first_cond_upper} is specified or if \code{join_type}
equals \code{"before"} or \code{"after"}.

If an expression is named, e.g., \code{exprs(EXSTDT = convert_dtc_to_dt(EXSTDTC), EXSEQ)}, a corresponding variable (\code{EXSTDT}) is
added to the additional dataset and can be used in the filter conditions
(\code{filter_add}, \code{filter_join}) and for \code{join_vars} and \code{new_vars}. The
variable is not included in the output dataset.

For handling of \code{NA}s in sorting variables see the "Sort Order" section in \code{vignette("generic")}.

\describe{
\item{Permitted values}{list of expressions created by \code{exprs()}, e.g., \code{exprs(ADT, desc(AVAL))} or \code{NULL}}
\item{Default value}{\code{NULL}}
}}

\item{new_vars}{Variables to add

The new variables can be defined by named expressions, i.e., \verb{new_vars = exprs(<new variable> = <value>)}. The value must be defined such that it
results in a single record per by group, e.g., by using a summary function
like \code{mean()}, \code{sum()}, ...

\describe{
\item{Permitted values}{list of named expressions created by \code{exprs()}, e.g., \code{exprs(CUMDOSA = sum(AVAL, na.rm = TRUE), AVALU = "ml")}}
\item{Default value}{none}
}}

\item{tmp_obs_nr_var}{Temporary observation number

The specified variable is added to the input dataset (\code{dataset}) and the
restricted additional dataset (\code{dataset_add} after applying \code{filter_add}).
It is set to the observation number with respect to \code{order}. For each by
group (\code{by_vars}) the observation number starts with \code{1}. The variable can
be used in the conditions (\code{filter_join}, \code{first_cond_upper},
\code{first_cond_lower}). It can also be used to select consecutive observations
or the last observation.

The variable is not included in the output dataset. To include it specify
it for \code{new_vars}.

\describe{
\item{Permitted values}{an unquoted symbol, e.g., \code{AVAL}}
\item{Default value}{\code{NULL}}
}}

\item{join_vars}{Variables to use from additional dataset

Any extra variables required from the additional dataset for \code{filter_join}
should be specified for this argument. Variables specified for \code{new_vars}
do not need to be repeated for \code{join_vars}. If a specified variable exists
in both the input dataset and the additional dataset, the suffix ".join" is
added to the variable from the additional dataset.

If an expression is named, e.g., \code{exprs(EXSTDT = convert_dtc_to_dt(EXSTDTC))}, a corresponding variable is added to the
additional dataset and can be used in the filter conditions (\code{filter_add},
\code{filter_join}) and for \code{new_vars}.

The variables are not included in the output dataset.

\describe{
\item{Permitted values}{list of variables or named expressions created by \code{exprs()}, e.g., \code{exprs(EXSTDY, EXSTDTM = convert_dtc_to_dtm(EXSTDTC))}}
\item{Default value}{\code{NULL}}
}}

\item{join_type}{Observations to keep after joining

The argument determines which of the joined observations are kept with
respect to the original observation. For example, if \code{join_type = "after"}
is specified all observations after the original observations are kept.

\describe{
\item{Permitted values}{\code{"before"}, \code{"after"}, \code{"all"}}
\item{Default value}{none}
}}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations from \code{dataset_add} fulfilling the specified condition are
joined to the input dataset. If the argument is not specified, all
observations are joined.

Variables created by \code{order} or \code{new_vars} arguments can be used in the
condition.

The condition can include summary functions like \code{all()} or \code{any()}. The
additional dataset is grouped by the by variables (\code{by_vars}).

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}

\item{first_cond_lower}{Condition for selecting range of data (before)

If this argument is specified, the other observations are restricted from
the first observation before the current observation where the specified
condition is fulfilled up to the current observation. If the condition is
not fulfilled for any of the other observations, no observations are
considered.

This argument should be specified if \code{filter_join} contains summary
functions which should not apply to all observations but only from a
certain observation before the current observation up to the current
observation. For an example see the last example below.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}

\item{first_cond_upper}{Condition for selecting range of data (after)

If this argument is specified, the other observations are restricted up to
the first observation where the specified condition is fulfilled. If the
condition is not fulfilled for any of the other observations, no
observations are considered.

This argument should be specified if \code{filter_join} contains summary
functions which should not apply to all observations but only up to the
confirmation assessment. For an example see the last example below.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}

\item{filter_join}{Filter for the joined dataset

The specified condition is applied to the joined dataset. Therefore
variables from both datasets \code{dataset} and \code{dataset_add} can be used.

Variables created by \code{order} or \code{new_vars} arguments can be used in the
condition.

The condition can include summary functions like \code{all()} or \code{any()}. The
joined dataset is grouped by the original observations.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}

\item{missing_values}{Values for non-matching observations

For observations of the input dataset (\code{dataset}) which do not have a
matching observation in the additional dataset (\code{dataset_add}) the values
of the specified variables are set to the specified value. Only variables
specified for \code{new_vars} can be specified for \code{missing_values}.

\describe{
\item{Permitted values}{list of named expressions created by a formula using \code{exprs()}, e.g., \code{exprs(AVALC = VSSTRESC, AVAL = yn_to_numeric(AVALC))}}
\item{Default value}{\code{NULL}}
}}

\item{check_type}{Check uniqueness?

If \code{"message"}, \code{"warning"} or \code{"error"} is specified, the specified
message is issued if the observations of the input dataset (\code{dataset}) or
the restricted additional dataset (\code{dataset_add} after applying
\code{filter_add}) are not unique with respect to the by variables and the
order.

The uniqueness is checked only if \code{tmp_obs_nr_var}, \code{first_cond_lower},
or \code{first_cond_upper} is specified or \code{join_type} equals \code{"before"} or
\code{"after"}.

\describe{
\item{Permitted values}{\code{"none"}, \code{"message"}, \code{"warning"}, \code{"error"}}
\item{Default value}{\code{"warning"}}
}}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variables specified for \code{new_vars}
derived from the additional dataset (\code{dataset_add}).
}
\description{
The function summarizes variables from an additional dataset and adds the
summarized values as new variables to the input dataset. The selection of the
observations from the additional dataset can depend on variables from both
datasets. For example, all doses before the current observation can be
selected and the sum be added to the input dataset.
}
\details{
\enumerate{
\item The variables specified by \code{order} are added to the additional dataset
(\code{dataset_add}).
\item The variables specified by \code{join_vars} are added to the additional dataset
(\code{dataset_add}).
\item The records from the additional dataset (\code{dataset_add}) are restricted to
those matching the \code{filter_add} condition.
\item The input dataset and the (restricted) additional dataset are left joined
by the grouping variables (\code{by_vars}). If no grouping variables are
specified, a full join is performed.
\item If \code{first_cond_lower} is specified, for each observation of the input
dataset the joined dataset is restricted to observations from the first
observation where \code{first_cond_lower} is fulfilled (the observation fulfilling
the condition is included) up to the observation of the input dataset. If for
an observation of the input dataset the condition is not fulfilled, the
observation is removed.

If \code{first_cond_upper} is specified, for each observation of the input
dataset the joined dataset is restricted to observations up to the first
observation where \code{first_cond_upper} is fulfilled (the observation
fulfilling the condition is included). If for an observation of the input
dataset the condition is not fulfilled, the observation is removed.

For an example see the last example in the "Examples" section.
\item The joined dataset is restricted by the \code{filter_join} condition.
\item The variables specified for \code{new_vars} are created and merged to the input
dataset. I.e., the output dataset contains all observations from the input
dataset. For observations without a matching observation in the joined
dataset the new variables are set as specified by \code{missing_values} (or to
\code{NA} for variables not in \code{missing_values}). Observations in the additional
dataset which have no matching observation in the input dataset are ignored.
}

\strong{Note:} This function creates temporary datasets which may be much bigger
than the input datasets. If this causes memory issues, please try setting
the admiral option \code{save_memory} to \code{TRUE} (see \code{set_admiral_options()}).
This reduces the memory consumption but increases the run-time.
}
\seealso{
\code{\link[=derive_vars_joined]{derive_vars_joined()}}, \code{\link[=derive_vars_merged_summary]{derive_vars_merged_summary()}},
\code{\link[=derive_var_joined_exist_flag]{derive_var_joined_exist_flag()}}, \code{\link[=filter_joined]{filter_joined()}}

General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_joined_exist_flag}()},
\code{\link{derive_var_merged_ef_msrc}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_var_relative_flag}()},
\code{\link{derive_vars_cat}()},
\code{\link{derive_vars_computed}()},
\code{\link{derive_vars_joined}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_merged_summary}()},
\code{\link{derive_vars_transposed}()}
}
\concept{der_gen}
\keyword{der_gen}
\section{Examples}{


The examples focus on the functionality specific to this function. For
examples of functionality common to all "joined" functions like
\code{filter_join}, \code{filter_add}, \code{join_vars}, ... please see the examples
of \code{\link[=derive_vars_joined]{derive_vars_joined()}}.
\subsection{Derive cumulative dose before event (\code{CUMDOSA})}{

Deriving the cumulative actual dose up to the day of the adverse event
in the \code{ADAE} dataset.
\itemize{
\item \code{USUBJID} is specified for \code{by_vars} to join the \code{ADAE} and the \code{ADEX}
dataset by subject.
\item \code{filter_join} is specified to restrict the \code{ADEX} dataset to the days up
to the adverse event. \code{ADY.join} refers to the study day in \code{ADEX}.
\item The new variable \code{CUMDOSA} is defined by the \code{new_vars} argument. It is
set to the sum of \code{AVAL}.
\item As \code{ADY} from \code{ADEX} is used in \code{filter_join} (but not in \code{new_vars}), it
needs to be specified for \code{join_vars}.
\item The \code{join_type} is set to \code{"all"} to consider all records in the joined
dataset. \code{join_type = "before"} can't by used here because then doses at
the same day as the adverse event would be excluded.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tibble)
library(dplyr, warn.conflicts = FALSE)

adex <- tribble(
  ~USUBJID, ~ADY, ~AVAL,
  "1",         1,    10,
  "1",         8,    20,
  "1",        15,    10,
  "2",         8,     5
)

adae <- tribble(
  ~USUBJID, ~ADY, ~AEDECOD,
  "1",         2, "Fatigue",
  "1",         9, "Influenza",
  "1",        15, "Theft",
  "1",        15, "Fatigue",
  "2",         4, "Parasomnia",
  "3",         2, "Truancy"
)

derive_vars_joined_summary(
  dataset = adae,
  dataset_add = adex,
  by_vars = exprs(USUBJID),
  filter_join = ADY.join <= ADY,
  join_type = "all",
  join_vars = exprs(ADY),
  new_vars = exprs(CUMDOSA = sum(AVAL, na.rm = TRUE))
)
#> # A tibble: 6 × 4
#>   USUBJID   ADY AEDECOD    CUMDOSA
#>   <chr>   <dbl> <chr>        <dbl>
#> 1 1           2 Fatigue         10
#> 2 1           9 Influenza       30
#> 3 1          15 Theft           40
#> 4 1          15 Fatigue         40
#> 5 2           4 Parasomnia      NA
#> 6 3           2 Truancy         NA}\if{html}{\out{</div>}}}
\subsection{Define values for records without records in the additional dataset (\code{missing_values})}{

By default, the new variables are set to \code{NA} for records without
matching records in the restricted additional dataset. This can be changed
by specifying the \code{missing_values} argument.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_vars_joined_summary(
  dataset = adae,
  dataset_add = adex,
  by_vars = exprs(USUBJID),
  filter_join = ADY.join <= ADY,
  join_type = "all",
  join_vars = exprs(ADY),
  new_vars = exprs(CUMDOSE = sum(AVAL, na.rm = TRUE)),
  missing_values = exprs(CUMDOSE = 0)
)
#> # A tibble: 6 × 4
#>   USUBJID   ADY AEDECOD    CUMDOSE
#>   <chr>   <dbl> <chr>        <dbl>
#> 1 1           2 Fatigue         10
#> 2 1           9 Influenza       30
#> 3 1          15 Theft           40
#> 4 1          15 Fatigue         40
#> 5 2           4 Parasomnia       0
#> 6 3           2 Truancy          0}\if{html}{\out{</div>}}}
\subsection{Selecting records (\code{join_type = "before"}, \code{join_type = "after"})}{

The \code{join_type} argument can be used to select records from the
additional dataset. For example, if \code{join_type = "before"} is specified,
only records before the current observation are selected. If \code{join_type = "after"} is specified, only records after the current observation are
selected.

To illustrate this, a variable (\code{SELECTED_DAYS}) is derived which contains
the selected days.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mydata <- tribble(
  ~DAY,
  1,
  2,
  3,
  4,
  5
)

derive_vars_joined_summary(
  mydata,
  dataset_add = mydata,
  order = exprs(DAY),
  join_type = "before",
  new_vars = exprs(SELECTED_DAYS = paste(DAY, collapse = ", "))
)
#> # A tibble: 5 × 2
#>     DAY SELECTED_DAYS
#>   <dbl> <chr>        
#> 1     1 <NA>         
#> 2     2 1            
#> 3     3 1, 2         
#> 4     4 1, 2, 3      
#> 5     5 1, 2, 3, 4   

derive_vars_joined_summary(
  mydata,
  dataset_add = mydata,
  order = exprs(DAY),
  join_type = "after",
  new_vars = exprs(SELECTED_DAYS = paste(DAY, collapse = ", "))
)
#> # A tibble: 5 × 2
#>     DAY SELECTED_DAYS
#>   <dbl> <chr>        
#> 1     1 2, 3, 4, 5   
#> 2     2 3, 4, 5      
#> 3     3 4, 5         
#> 4     4 5            
#> 5     5 <NA>         }\if{html}{\out{</div>}}}
\subsection{Selecting records (\code{first_cond_lower}, \code{first_cond_upper})}{

The \code{first_cond_lower} and \code{first_cond_upper} arguments can be used to
restrict the joined dataset to a certain range of records. For example, if
\code{first_cond_lower} is specified, the joined dataset is restricted to the
last observation before the current record where the condition is
fulfilled.

Please note:
\itemize{
\item If the condition is not fulfilled for any of the records, no records are
selected.
\item The restriction implied by \code{join_type} is applied first.
\item If a variable is contained in both \code{dataset} and \code{dataset_add} like \code{DAY}
in the example below, \code{DAY} refers to the value from \code{dataset} and
\code{DAY.join} to the value from \code{dataset_add}.
}

To illustrate this, a variable (\code{SELECTED_DAYS}) is derived which contains
the selected days.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_vars_joined_summary(
  mydata,
  dataset_add = mydata,
  order = exprs(DAY),
  join_type = "before",
  first_cond_lower = DAY.join == 2,
  new_vars = exprs(SELECTED_DAYS = paste(sort(DAY), collapse = ", "))
)
#> # A tibble: 5 × 2
#>     DAY SELECTED_DAYS
#>   <dbl> <chr>        
#> 1     1 <NA>         
#> 2     2 <NA>         
#> 3     3 2            
#> 4     4 2, 3         
#> 5     5 2, 3, 4      

derive_vars_joined_summary(
  mydata,
  dataset_add = mydata,
  order = exprs(DAY),
  join_type = "after",
  first_cond_upper = DAY.join == 4,
  new_vars = exprs(SELECTED_DAYS = paste(DAY, collapse = ", "))
)
#> # A tibble: 5 × 2
#>     DAY SELECTED_DAYS
#>   <dbl> <chr>        
#> 1     1 2, 3, 4      
#> 2     2 3, 4         
#> 3     3 4            
#> 4     4 <NA>         
#> 5     5 <NA>         

derive_vars_joined_summary(
  mydata,
  dataset_add = mydata,
  order = exprs(DAY),
  join_type = "all",
  first_cond_lower = DAY.join == 2,
  first_cond_upper = DAY.join == 4,
  new_vars = exprs(SELECTED_DAYS = paste(sort(DAY), collapse = ", "))
)
#> # A tibble: 5 × 2
#>     DAY SELECTED_DAYS
#>   <dbl> <chr>        
#> 1     1 2, 3, 4      
#> 2     2 2, 3, 4      
#> 3     3 2, 3, 4      
#> 4     4 2, 3, 4      
#> 5     5 2, 3, 4      }\if{html}{\out{</div>}}}
\subsection{Derive weekly score if enough assessments are available}{

For each planned visit the average score within the week before the
visit should be derived if at least three assessments are available.

Please note that the condition for the number of assessments is specified
in \code{new_vars} and not in \code{filter_join}. This is because the number of
assessments within the week before the visit should be counted but not the
number of assessments available for the subject.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{planned_visits <- tribble(
  ~AVISIT,  ~ADY,
  "WEEK 1",    8,
  "WEEK 4",   29,
  "WEEK 8",   57
  ) \%>\%
  mutate(USUBJID = "1", .before = AVISIT)

adqs <- tribble(
  ~ADY, ~AVAL,
     1,    10,
     2,    12,
     4,     9,
     5,     9,
     7,    10,
    25,    11,
    27,    10,
    29,    10,
    41,     8,
    42,     9,
    44,     5
) \%>\%
mutate(USUBJID = "1")

derive_vars_joined_summary(
  planned_visits,
  dataset_add = adqs,
  by_vars = exprs(USUBJID),
  filter_join = ADY - 7 <= ADY.join & ADY.join < ADY,
  join_type = "all",
  join_vars = exprs(ADY),
  new_vars = exprs(AVAL = if_else(n() >= 3, mean(AVAL, na.rm = TRUE), NA))
)
#> # A tibble: 3 × 4
#>   USUBJID AVISIT   ADY  AVAL
#>   <chr>   <chr>  <dbl> <dbl>
#> 1 1       WEEK 1     8    10
#> 2 1       WEEK 4    29    NA
#> 3 1       WEEK 8    57    NA}\if{html}{\out{</div>}}}}

