% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.adjroc.R
\name{boot.adjroc}
\alias{boot.adjroc}
\title{boot.adjroc}
\usage{
boot.adjroc(
  score,
  class,
  n = 100,
  method = "emp",
  sensitivity = NULL,
  specificity = NULL
)
}
\arguments{
\item{score}{A numeric array of diagnostic score i.e. the estimated probability of each diagnosis}

\item{class}{A numeric array of equal length of \code{"score"}, including the actual class of the observations}

\item{n}{number of bootstrap samples.}

\item{method}{Specifies the method for estimating the ROC curve. Three methods are supported, which are \code{"empirical"}, \code{"binormal"}, and \code{"nonparametric"}}

\item{sensitivity}{numeric. Specify the threshold of sensitivity.}

\item{specificity}{numeric. Specify the threshold of specificity.}
}
\value{
list including mean and CI of bootstrap value (sensitivity, specificity, or
    the crossing point) and the bootstrap data.
}
\description{
computes bootstrap adjusted sensitivity, bootstrap adjusted
    specificity, or bootstrap crossing point between sensitivity and
    specificity for different thresholds
}
\examples{
# random classification and probability score
score <- runif(10000, min=0, max=1)
class <- sample(x = c(1,0), 10000, replace=TRUE)

# calculate adjusted sensitivity, when specificity threshold is 0.90:
adjroc(score = score, class = class, specificity = 0.9, plot = TRUE)

# calculate adjusted specificity, when sensitivity threshold equals 0.9
boot.adjroc(score = score, class = class, n = 100, sensitivity = 0.9)

# calculate the bootstrap meeting point between sensitivity and specificity
boot.adjroc(score = score, class = class, n = 100)
}
