% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glintnet.R
\name{predict.cv.glintnet}
\alias{predict.cv.glintnet}
\alias{coef.cv.glintnet}
\title{make predictions from a "cv.glintnet" object.}
\usage{
\method{predict}{cv.glintnet}(object, newx, lambda = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{Fitted \code{"cv.glintnet"}.}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be
made. This matrix is of the same form as in the call to \code{glintnet}.}

\item{lambda}{Value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the entire sequence used to create the
model. If values of \code{lambda} are supplied, the function uses linear
interpolation to make predictions for values of \code{lambda} that do
not coincide with those used in the fitting algorithm. Note: if newx is a vector
(a single row which has lost its matrix dimensions), convert it to a 1-row matrix first, e.g. by supplying t(newx) instead.}

\item{...}{Other arguments that can be passed to \code{predict.grpnet}}
}
\description{
This function makes predictions from a cross-validated \code{glintnet} model, using
the stored \code{"glintnet.fit"} object, and the optimal value chosen for
\code{lambda}.
}
\details{
This function makes it easier to use the results of cross-validation to make
a prediction.
}
\examples{
set.seed(0)
n=500
d_cont = 5     # number of continuous features
d_disc = 5     # number of categorical features
Z_cont = matrix(rnorm(n*d_cont), n, d_cont)
levels = sample(2:5,d_disc, replace = TRUE)
Z_disc = matrix(0,n,d_disc)
for(i in seq(d_disc))Z_disc[,i] = sample(0:(levels[i]-1),n,replace=TRUE)
Z = cbind(Z_cont,Z_disc)
levels = c(rep(1,d_cont),levels)

xmat = model.matrix(~Z_cont[,1]*factor(Z_disc[,2]))
nc=ncol(xmat)
beta = rnorm(nc)
y = xmat\%*\%beta+rnorm(n)*1.5

cvfit <- cv.glintnet(Z, glm.gaussian(y), levels=levels, intr_keys = 1)
plot(cvfit)
predict(cvfit, newx=Z[1:5,])

}
