% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{summary.adaptInv}
\alias{summary.adaptInv}
\title{Summarize adaptInv Objects}
\usage{
\method{summary}{adaptInv}(object, ...)
}
\arguments{
\item{object}{An \code{adaptInv} object.}

\item{...}{Other parameters currently not utilized.}
}
\value{
This function only produces text summarizing the numbers of variants,
time steps, replicates, ESS optima, etc.
}
\description{
Function \code{summary.adaptInv()} summarizes \code{adaptInv} objects.
}
\examples{
\donttest{
library(lefko3)
data(cypdata)

sizevector <- c(0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "SL", "D", "XSm", "Sm", "Md", "Lg", "XLg")
repvector <- c(0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.40, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, 1000, 1000),
  type =c(1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")
cypmean <- lmean(cypmatrix2r)

cyp_start <- start_input(cypmean, stage2 = c("SD", "P1", "D"),
  value = c(1000, 200, 4))

c2d_4 <- density_input(cypmean, stage3 = c("P1", "P1"), stage2= c("SD", "rep"),
  style = 2, time_delay = 1, alpha = 0.005, beta = 0.000005, type = c(2, 2))

# A simple projection allows us to find a combination of density dependence
# and running time that produces a stable quasi-equilibrium
cyp_proj <- projection3(cypmean, times = 250, start_frame = cyp_start,
  density = c2d_4, integeronly = TRUE)
plot(cyp_proj)

cyp_ta <- trait_axis(stageframe = cypframe_raw,
  stage3 = rep("P1", 15),
  stage2 = rep("rep", 15),
  multiplier = seq(from = 0.1, to = 10.0, length.out = 15),
  type = rep(2, 15))

cyp_inv <- invade3(axis = cyp_ta, mpm = cypmean, density = c2d_4, times = 350,
  starts = cyp_start, entry_time = c(0, 250), fitness_times = 30,
  var_per_run = 2)
summary(cyp_inv)
}

}
