% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMC.R
\name{buhlmannStraubGLM}
\alias{buhlmannStraubGLM}
\title{Combining the Buhlmann-Straub credibility model with a GLM (Ohlsson, 2008)}
\usage{
buhlmannStraubGLM(
  formula,
  data,
  weights,
  p = 1.5,
  link.power = 0,
  muHatGLM = FALSE,
  epsilon = 1e-04,
  maxiter = 500,
  maxiterGLM = 500,
  verbose = FALSE,
  returnData = TRUE,
  balanceProperty = TRUE,
  y = TRUE,
  ...
)
}
\arguments{
\item{formula}{object of type \code{\link{formula}} that specifies which model should be fitted. Syntax follows
\code{\link[lme4]{lmer}}: e.g., \code{Y ~ x1 + x2 + (1 | Cluster)}. Only one random effect is allowed.}

\item{data}{an object that is coercible by \code{\link[data.table]{as.data.table}}, containing the variables in the model.}

\item{weights}{variable name of the exposure weight.}

\item{p}{the value for the power parameter of the Tweedie distribution, which is passed to \code{\link[statmod]{tweedie}}. Default is \code{1.5}.}

\item{link.power}{index of power link function, which is passed to \code{\link[statmod]{tweedie}}. \code{link.power = 0} produces a log-link.
Defaults to the canonical link, which is \code{1 - p}.}

\item{muHatGLM}{indicates which estimate has to be used in the algorithm for the intercept term. Default is \code{TRUE},
which uses the intercept as estimated by the GLM. If \code{FALSE}, the estimate of the Buhlmann-Straub credibility model is used.}

\item{epsilon}{positive convergence tolerance \eqn{\epsilon}; the iterations converge when
\eqn{||\theta[k] - \theta[k - 1]||^2_2/||\theta[k - 1]||^2_2 < \epsilon}. Here, \eqn{\theta[k]} is the parameter vector at the \eqn{k^{th}} iteration.}

\item{maxiter}{maximum number of iterations.}

\item{maxiterGLM}{maximum number of iterations when fitting the GLM part. Passed to \code{glm}.}

\item{verbose}{logical indicating if output should be produced during the algorithm.}

\item{returnData}{logical indicating if input data has to be returned.}

\item{balanceProperty}{logical indicating if the balance property should be satisfied.}

\item{y}{logical indicating whether the response vector should be returned as a component of the returned value.}

\item{...}{arguments passed to \code{glm}}
}
\value{
An object of type \code{buhlmannStraubGLM} with the following slots:

\item{call}{the matched call}

\item{CredibilityResults}{results of the Buhlmann-Straub credibility model.}

\item{fitGLM}{the results from fitting the GLM part.}

\item{iter}{total number of iterations.}

\item{Converged}{logical indicating whether the algorithm converged.}

\item{LevelsCov}{object that summarizes the unique levels of each of the contract-specific covariates.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}

\item{prior.weights}{the weights (exposure) initially supplied.}

\item{y}{if requested, the response vector. Default is \code{TRUE}.}
}
\description{
Fit a single-level random effects model using Ohlsson's methodology combined with Buhlmann-Straub credibility.
This is the single-level analogue of \code{\link{hierCredGLM}}.
}
\examples{
\donttest{
data("hachemeister", package = "actuar")
# Prepare data
X = as.data.frame(hachemeister)
Df = reshape(X, idvar = "state",
             varying = list(paste0("ratio.", 1:12), paste0("weight.", 1:12)),
             direction = "long")
# Add a covariate
Df$time_factor = factor(Df$time)
# Fit model
fit = buhlmannStraubGLM(ratio.1 ~ time_factor + (1 | state), Df,
                        weights = weight.1, p = 1.5)
summary(fit)
ranef(fit)
}
}
\references{
Campo, B.D.C. and Antonio, Katrien (2023). Insurance pricing with hierarchically structured data an illustration with a workers' compensation insurance portfolio. \emph{Scandinavian Actuarial Journal}, doi: 10.1080/03461238.2022.2161413

Ohlsson, E. (2008). Combining generalized linear models and credibility models in practice. \emph{Scandinavian Actuarial Journal} \bold{2008}(4), 301–314.
}
\seealso{
\code{\link{buhlmannStraubGLM-class}}, \code{\link{buhlmannStraubTweedie}}, \code{\link{buhlmannStraub}}, \code{\link{plotRE}},
\code{\link{adjustIntercept}}, \code{\link{BalanceProperty}}, \code{\link{tweedieGLMM}}
}
