% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{emptyMatrix}
\alias{emptyMatrix}
\title{Create a Template Distances Matrix}
\usage{
emptyMatrix(input = "spatial.csv")
}
\arguments{
\item{input}{Either a data frame with spatial data or the path to the file containing the spatial information.}
}
\value{
An empty matrix with the rows and columns required to
operate with the target spatial file.
}
\description{
Creates an empty matrix based on the local 'spatial.csv' file and saves it to 'distances.csv' so the
user can manually fill it.
}
\details{
It is highly recommended to read the manual page regarding distances matrices before running this function.
You can find it here: \href{https://hugomflavio.github.io/actel-website/manual-distances.html}{https://hugomflavio.github.io/actel-website/manual-distances.html}
}
\examples{
# This function requires a file with spatial information

# Fetch location of actel's example files
aux <- system.file(package = "actel")[1]

# run emptyMatrix on the temporary spatial.csv file
emptyMatrix(paste0(aux, "/example_spatial.csv"))

}
