% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptprism.R
\name{pptprism}
\alias{pptprism}
\title{Calculating precipitation by PRISM grids or Counties with PRISM raster}
\usage{
pptprism(mmprism, year, out = NULL)
}
\arguments{
\item{mmprism}{A PRISM raster of the precipitation}

\item{year}{year of the PRIsM raster}

\item{out}{Output value type: precipitation by PRISM grids or Counties (default = Counties)}
}
\value{
A data.frame including precipitation (ppt), PRISM grid numbers (gridNum), or FIPS codes (stco)
}
\description{
The function calculates the precipitation (mm) by grids or counties directly from a PRISM raster.
}
\details{
\code{pptprism} is a function for calculating precipitation (mm) by PRISM grids or Counties directly from a PRISM raster.\cr
\cr
The \code{out} is to specify the output values.\cr
- \code{out = 'grid'}: precipitation by PRISM grids projected on the NLCD map
\cr
- \code{out = 'stco'}: precipitation by Counties of 2017 Agricultural Census (default)
\cr
If \code{out} is not specified, 'stco' is set as default.\cr
\cr
When \code{out='stco'} is specified, the weights are applied as:\cr
- year < 2004: agricultural areas in 2001 NLCD
\cr
- year = 2004 or 2005: agricultural areas in 2004 NLCD
\cr
- year = 2006 or 2007: agricultural areas in 2006 NLCD
\cr
- year = 2008, 2009, or 2010: agricultural areas in 2008 NLCD
\cr
- year = 2011 or 2012: agricultural areas in 2011 NLCD
\cr
- year = 2013, 2014, or 2015: agricultural areas in 2013 NLCD
\cr
- year = 2016, 2017, or 2018: agricultural areas in 2016 NLCD
\cr
- year >= 2019: agricultural areas in 2019 NLCD\cr
\cr
To get a PRIMS raster, follow the instruction at \url{https://prism.oregonstate.edu/documents/PRISM_downloads_FTP.pdf}.
}
\examples{
#######################################################
## Note: Need a PRISM raster to run this code
#######################################################
\dontrun{
## PRISM data import
pptdata <- raster('./PRISM_ppt_stable_4kmD2_19960701_bil.bil')
## precipitation over Counties
result <- pptprism(pptdata,1996)
result2 <- pptprism(pptdata,1996,'stco')
## precipitation over PRISM grids
result3 <- pptprism(pptdata,1996,'grid')
}
}
\seealso{
\code{\link{gddprism}, \link{grid2stco}}
}
