% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prior.R
\name{plot_prior}
\alias{plot_prior}
\title{Plot Prior}
\usage{
plot_prior(
  prior_par = list(mu_psi = 0, sigma_psi = 1, mu_beta = 0, sigma_beta = 1),
  what = "logor",
  hypothesis = "H1",
  p1 = 0.5,
  ...
)
}
\arguments{
\item{prior_par}{list with prior parameters. This list needs to contain the
following elements: \code{mu_psi} (prior mean for the normal prior on the
test-relevant log odds ratio), \code{sigma_psi} (prior standard deviation
for the normal prior on the test-relevant log odds ratio), \code{mu_beta}
(prior mean for the normal prior on the grand mean of the log odds),
\code{sigma_beta} (prior standard deviation for the normal prior on the
grand mean of the log odds). Each of the elements needs to be a real number
(the standard deviations need to be positive). The default are standard
normal priors for both the log odds ratio parameter and the grand mean of
the log odds parameter.}

\item{what}{character specifying for which quantity the prior should be
plotted. Either \code{"logor"} (i.e., log odds ratio) , \code{"or"} (i.e.,
odds ratio), \code{"p1p2"} (i.e., plots the joint distribution of the
latent "success" probability in the experimental and control condition),
\code{"p1"} (i.e., latent "success" probability in the control condition),
\code{"p2"} (i.e., latent "success" probability in the experimental
condition), \code{"p2givenp1"} (i.e., plots the conditional distribution of
the latent "success" probability in the experimental condition given a
"success" probability of \code{p1} in the control condition),
\code{"rrisk"} (i.e., relative risk, the ratio of the "success" probability
in the experimental and the control condition), or \code{"arisk"} (i.e.,
absolute risk, the difference of the "success" probability in the
experimental and control condition).}

\item{hypothesis}{character specifying whether to plot a two-sided prior
(i.e., "H1"), a one-sided prior with lower truncation point (i.e., "H+"),
or a one-sided prior with upper truncation point (i.e., "H-").}

\item{p1}{value of the "success" probability in the control condtion. Only
used when \code{what = "p2givenp1"}.}

\item{...}{further arguments.}
}
\description{
Function for plotting parameter prior distributions.
}
\note{
Internally, the test-relevant prior is always a normal prior on the log
  odds ratio, however, the \code{plot_prior} function also allows one to plot
  the implied prior on different quantities.
}
\examples{
# prior parameters
prior_par <- list(mu_psi = 0, sigma_psi = 1,
                  mu_beta = 0, sigma_beta = 1)

# plot prior
plot_prior(prior_par = prior_par, what = "logor")
plot_prior(prior_par = prior_par, what = "or")
plot_prior(prior_par = prior_par, what = "p1p2")
plot_prior(prior_par = prior_par, what = "p1")
plot_prior(prior_par = prior_par, what = "p2")
plot_prior(prior_par = prior_par, what = "p2givenp1", p1 = 0.3)
plot_prior(prior_par = prior_par, what = "rrisk")
plot_prior(prior_par = prior_par, what = "arisk")
}
\author{
Quentin F. Gronau
}
