% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicit_prior.R
\name{elicit_prior}
\alias{elicit_prior}
\title{Elicit Prior}
\usage{
elicit_prior(
  q,
  prob,
  what = "logor",
  hypothesis = "H1",
  mu_beta = 0,
  sigma_beta = 1
)
}
\arguments{
\item{q}{vector with quantiles for the quantity of interest.}

\item{prob}{vector with probabilities corresponding to the quantiles (e.g., for
the median the corresponding element of \code{prob} would need to be .5).}

\item{what}{character specifying for which quantity a prior should be
elicited. Either \code{"logor"} (i.e., log odds ratio) , \code{"or"} (i.e.,
odds ratio), \code{"rrisk"} (i.e., relative risk, the ratio of the
"success" probability in the experimental and the control condition), or
\code{"arisk"} (i.e., absolute risk, the difference of the "success"
probability in the experimental and control condition).}

\item{hypothesis}{character specifying whether the provided quantiles
correspond to a two-sided prior (i.e., "H1"), a one-sided prior with lower
truncation point (i.e., "H+"), or a one-sided prior with upper truncation
point (i.e., "H-").}

\item{mu_beta}{prior mean of the nuisance parameter \eqn{\beta} (i.e., the
grand mean of the log odds). The default is 0.}

\item{sigma_beta}{prior standard deviation of the nuisance parameter
\eqn{\beta} (i.e., the grand mean of the log odds). The default is 1.}
}
\value{
list with the elicited prior parameters. Specifically, this list
  consists of: \itemize{ \item\code{mu_psi} (prior mean for the normal prior
  on the test-relevant log odds ratio). \item \code{sigma_psi} (prior
  standard deviation for the normal prior on the test-relevant log odds
  ratio), \item \code{mu_beta} (prior mean for the normal prior on the grand
  mean of the log odds), \item \code{sigma_beta} (prior standard deviation
  for the normal prior on the grand mean of the log odds).} Note that the
  prior on the grand mean of the log odds is not part of the elicitation and
  is assumed to be fixed by the user (using the arguments \code{mu_beta} and
  \code{sigma_beta}). Consequently, the returned values for \code{mu_beta}
  and \code{sigma_beta} simply correspond to the input values.
}
\description{
Function for eliciting a prior distribution.
}
\details{
It is assumed that the prior on the grand mean of the log odds
  (i.e., \eqn{\beta}) is not the primary target of prior elicitation and is
  fixed (e.g., to a standard normal prior). The reason is that the grand mean
  nuisance parameter \eqn{\beta} is not the primary target of inference and
  changes in the prior on this nuisance parameter do not affect the results
  much in most cases (see Kass & Vaidyanathan, 1992). Nevertheless, it should
  be emphasized that the implemented approach allows users to set the prior
  parameters \code{mu_beta} and \code{sigma_beta} flexibly; the only
  constraint is that this takes place before the prior on the test-relevant
  log odds ratio parameter \eqn{\psi} is elicited. The \code{elicit_prior}
  function allows the user to elicit a prior not only in terms of the log
  odds ratio parameter \eqn{\psi}, but also in terms of the odds ratio, the
  relative risk (i.e., the ratio of the "success" probability in the
  experimental and the control condition), or the absolute risk (i.e., the
  difference of the "success" probability in the experimental and control
  condition). In case the prior is not elicited for the log odds ratio
  directly, the elicited prior is always translated to the closest
  corresponding normal prior on the log odds ratio. The prior parameters
  \code{mu_psi} and \code{sigma_psi} are obtained using least squares
  minimization.
}
\examples{
# elicit prior
prior_par <- elicit_prior(q = c(0.1, 0.3, 0.5),
                          prob = c(.025, .5, .975),
                          what = "arisk")
print(prior_par)

# plot elicited prior (absolute risk)
plot_prior(prior_par = prior_par, what = "arisk")

# plot corresponding normal prior on log odds ratio
plot_prior(prior_par = prior_par, what = "logor")
}
\references{
Kass, R. E., & Vaidyanathan, S. K. (1992). Approximate Bayes
  factors and orthogonal parameters, with application to testing equality of
  two binomial proportions. \emph{Journal of the Royal Statistical Society,
  Series B, 54}, 129-144.
  \doi{10.1111/j.2517-6161.1992.tb01868.x}

  Gronau, Q. F., Raj K. N., A., & Wagenmakers, E.-J. (2021). Informed
  Bayesian Inference for the A/B Test. \emph{Journal of Statistical Software,
  100}. \doi{10.18637/jss.v100.i17}
}
\seealso{
The \code{\link{plot_prior}} function allows the user to visualize
  the elicited prior distribution.
}
\author{
Quentin F. Gronau
}
