% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{richness}
\alias{richness}
\title{Richness or number of observed species}
\usage{
richness(x)
}
\arguments{
\item{x}{A numeric vector of species counts or proportions.}
}
\value{
The number of species observed, \eqn{R \geq 0}.
}
\description{
Richness or number of observed species
}
\details{
The richness is simply the number of nonzero elements in \code{x}.
Relation to other definitions:
\itemize{
  \item Equivalent to \code{observed_otus()} in \code{skbio.diversity.alpha}.
  \item Equivalent to \code{specnumber} in \code{vegan}.
  \item Equivalent to the \code{sobs} calculator in Mothur.
}
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
richness(x) # 4
}
