% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_slime.R
\name{canvas_slime}
\alias{canvas_slime}
\title{Draw A Slime Mold}
\usage{
canvas_slime(
  colors,
  background = "#000000",
  iterations = 2000,
  agents = 1000,
  layout = c(
     "random", "gaussian", "circle", "grid",
     "clusters", "arrows", "wave", "spiral"
  ),
  resolution = 1000
)
}
\arguments{
\item{colors}{a character (vector) specifying the color(s) used for the
artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{a positive integer specifying the number of iterations of
the algorithm.}

\item{agents}{a positive integer specifying the number of agents to use.}

\item{layout}{a character specifying the initial layout of the agents.
Possible options are \code{random} (default), \code{gaussian},
\code{circle}, \code{grid}, \code{clusters}, \code{arrows} and \code{wave}.}

\item{resolution}{resolution of the artwork in pixels per row/column.
Increasing the resolution increases the quality of the artwork but also
increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws the Physarum polycephalum slime mold on a
  canvas. The algorithm simulates particles on a two-dimensional grid that
  move towards areas on the grid with a high intensity.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_slime(colors = colorPalette("neon1"))
}

}
\references{
\url{https://cargocollective.com/sagejenson/physarum}

\url{https://fronkonstin.com/2020/08/11/abstractions/}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
