% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootaRD.R
\name{bootaRD}
\alias{bootaRD}
\title{Bootstrapping for Risk Differences estimated by \code{aRD()}}
\usage{
bootaRD(object, ci_level = 0.95, R = 1000L, maxit = NULL, verbose = NULL, 
solver = NULL, eps_abs = NULL, eps_rel = NULL, 
polish_final = NULL, conswitch = NULL, use_nearPD = NULL)
}
\arguments{
\item{object}{An object of the class \code{"aRD"}.}

\item{ci_level}{A value between 0 and 1 indicating the confidence interval.
Provides bias-corrected accelerated bootstrap confidence intervals
of the original estimated model parameters of \code{aRD()}.}

\item{R}{A positive integer greater than or equal to 1000 giving the number of bootstrap replicates.}

\item{maxit}{A positive integer giving the maximum number of iterations in the \code{aRD()} algorithm.
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}

\item{verbose}{Logical; if TRUE, a detailed output is printed, including iteration logs,
objective values and solver messages (e.g., from \code{osqp}).
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}

\item{solver}{A character string specifying the solver to use. Options are "osqp" or "quadprog".
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}

\item{eps_abs}{Absolute tolerance for solver convergence (only used with "osqp").
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}

\item{eps_rel}{Relative tolerance for solver convergence (only used with "osqp").
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}

\item{polish_final}{Logical; if TRUE and solver is "osqp", performs a final polish step.
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}

\item{conswitch}{Specifies how the constraint matrix is constructed:
\describe{
  \item{1 (default)}{Generates all possible combinations of minimum and maximum values for the predictors (excluding the intercept), resulting in \eqn{2^{m-1}} constraints. 
  This formulation constrains model predictions within the observed data range, making it suitable for both risk factor identification and prediction (prognosis).}
  \item{0}{Uses the raw design matrix \code{x} as the constraint matrix, resulting in \eqn{n} constraints. 
  This is primarily suitable for identifying risk factors, but not for prediction tasks, as predictions are not bounded to realistic ranges.}
}
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}

\item{use_nearPD}{Logical; if \code{TRUE}, the Hessian matrix is projected to the nearest positive definite matrix 
using \code{Matrix::nearPD()} to ensure numerical stability, especially when using solvers that require a positive definite matrix 
(e.g., \code{quadprog}). If \code{FALSE}, the raw Hessian is used directly, which is faster but may lead to numerical issues 
if the matrix is not positive definite. Default is \code{TRUE}.
If \code{NULL} (the default), the value stored in the \code{aRD} object is passed internally to \code{bootaRD()}.}
}
\value{
An object of class \code{"aRD_boot"}, which is a list containing:
\describe{
  \item{Call_aRD}{The original call to the \code{aRD()} function used to fit the model.}
  \item{Successful_Bootstraps}{The number of bootstrap replicates that were completed successfully.}
  \item{message}{A character string with a status message indicating how many bootstrap samples succeeded.}
  \item{Coefficients}{A matrix with the original estimated model parameters (Orig. Est.), the mean of the bootstrap estimates (Boot. Est.), 
the standard error of the bootstrap estimates (Boot. SE), the difference between the bootstrap mean and the original estimate (bias),
the Risk Difference (equal to the estimate; RD), and the bias-corrected accelerated confidence intervals at the specified level.}
  \item{Bootstrap_Object}{An object of class \code{"boot"} (from the \pkg{boot} package) containing the full bootstrap output, 
    including replicates and metadata. This can be used for further analyses or plotting.}
}
}
\description{
\code{bootaRD()} applies nonparametric bootstrapping to an object of class \code{"aRD"} 
and computes bias-corrected accelerated confidence intervals (BCa) for the estimated risk differences.
}
\examples{
\donttest{
set.seed(123)
x <- rnorm(100, 50, 10)
y <- rbinom(100, 1, exp(-4 + x * 0.04))
library(aRD)
fit <- aRD(formula = y ~ x, data = data.frame(y = y, x = x))
result <- bootaRD(fit, ci_level = 0.90)
print(result)
}

}
\author{
Julius Johannes Weise, Thomas Wolf, Stefan Wagenpfeil
}
