% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FreqTM.R
\name{FreqTM}
\alias{FreqTM}
\title{FreqTM Generate Frequency Distribution Table for Fish Length Data Across Months}
\usage{
FreqTM(
  data,
  bin_width = NULL,
  Lmax = NULL,
  output_file = "FreqTM_Output.xlsx",
  date_config = list(day = 1, year = 2025)
)
}
\arguments{
\item{data}{A data frame containing columns for months and lengths (names can vary, e.g., 'Month', 'Length', or any other names).}

\item{bin_width}{Numeric value specifying the bin width for class intervals. If NULL (default), bin width is calculated using Wang's formula.}

\item{Lmax}{Numeric value for the maximum observed fish length. Required only if `bin_width` is NULL and Wang's formula is used. Defaults to NULL.}

\item{output_file}{Character string specifying the output Excel file name. Defaults to "FreqTM_Output.xlsx".}

\item{date_config}{A list with elements `day` (default 1) and `year` (default 2025) to set the day and year for converting month names to dates. The day must be between 1 and 31.}
}
\value{
A data frame with columns 'Length' (upper bound of each class) and monthly frequency columns as dates in 'day.month.year' format, where each row represents a length class and its frequency across months.
}
\description{
Creates a frequency distribution table for fish length data across multiple months using a consistent length class structure. The bin width is determined by either a custom value or Wang's formula, applied uniformly across all months. The function dynamically detects and renames columns to 'Month' and 'Length' from the input dataframe. The maximum observed length is included as part of the last class, with the upper bound set to the smallest multiple of the bin width greater than or equal to the maximum length. Months can be converted to dates using a configurable day and year, with dates assigned sequentially in 'day.month.year' format (e.g., 15.01.26).
}
\examples{
# Load required packages
library(dplyr)
library(openxlsx)

# Generate sample data with custom column names
set.seed(123)
sample_data <- data.frame(
  Time = rep(c("Aug", "Sep"), each = 100),
  Size = runif(200, min = 5, max = 20)
)

# Create frequency table with automatic bin width and default date config
result <- FreqTM(data = sample_data, output_file = tempfile(fileext = ".xlsx"))

# Create frequency table with custom bin width and specific date
result <- FreqTM(data = sample_data, bin_width = 2,
                        date_config = list(day = 15, year = 2026),
                        output_file = tempfile(fileext = ".xlsx"))

}
